/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;

public abstract class FieldUnivariateDerivative<S extends CalculusFieldElement<S>, T extends FieldUnivariateDerivative<S, T>>
implements FieldDerivative<S, T> {
    protected FieldUnivariateDerivative() {
    }

    @Override
    public int getFreeParameters() {
        return 1;
    }

    @Override
    public S getPartialDerivative(int ... orders) throws MathIllegalArgumentException {
        if (orders.length != 1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, orders.length, 1);
        }
        return this.getDerivative(orders[0]);
    }

    public abstract S getDerivative(int var1) throws MathIllegalArgumentException;

    public abstract FieldDerivativeStructure<S> toDerivativeStructure();
}

