/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.analysis.differentiation.DSCompiler;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.DifferentialAlgebra;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.MathUtils;

public class TaylorMap
implements DifferentialAlgebra {
    private final double[] point;
    private final DerivativeStructure[] functions;

    public TaylorMap(double[] point, DerivativeStructure[] functions) {
        if (point == null || point.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, point == null ? 0 : point.length);
        }
        if (functions == null || functions.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, functions == null ? 0 : functions.length);
        }
        this.point = (double[])point.clone();
        this.functions = (DerivativeStructure[])functions.clone();
        DSFactory factory0 = functions[0].getFactory();
        MathUtils.checkDimension(point.length, factory0.getCompiler().getFreeParameters());
        for (int i = 1; i < functions.length; ++i) {
            factory0.checkCompatibility(functions[i].getFactory());
        }
    }

    public TaylorMap(int parameters, int order, int nbFunctions) {
        this(parameters, nbFunctions);
        DSFactory factory = new DSFactory(parameters, order);
        for (int i = 0; i < nbFunctions; ++i) {
            this.functions[i] = factory.variable(i, 0.0);
        }
    }

    private TaylorMap(int parameters, int nbFunctions) {
        this.point = new double[parameters];
        this.functions = new DerivativeStructure[nbFunctions];
    }

    @Override
    public int getFreeParameters() {
        return this.point.length;
    }

    @Override
    public int getOrder() {
        return this.functions[0].getOrder();
    }

    public int getNbFunctions() {
        return this.functions.length;
    }

    public double[] getPoint() {
        return (double[])this.point.clone();
    }

    public DerivativeStructure getFunction(int i) {
        return this.functions[i];
    }

    private TaylorMap subtract(TaylorMap map) {
        TaylorMap result = new TaylorMap(this.point.length, this.functions.length);
        for (int i = 0; i < result.functions.length; ++i) {
            result.functions[i] = this.functions[i].subtract(map.functions[i]);
        }
        return result;
    }

    public double[] value(double ... deltaP) {
        double[] value = new double[this.functions.length];
        for (int i = 0; i < this.functions.length; ++i) {
            value[i] = this.functions[i].taylor(deltaP);
        }
        return value;
    }

    public TaylorMap compose(TaylorMap other) {
        MathUtils.checkDimension(this.getFreeParameters(), other.getNbFunctions());
        DerivativeStructure[] composed = new DerivativeStructure[this.functions.length];
        for (int i = 0; i < this.functions.length; ++i) {
            composed[i] = this.functions[i].rebase(other.functions);
        }
        return new TaylorMap(other.point, composed);
    }

    public TaylorMap invert(MatrixDecomposer decomposer) {
        DSFactory factory = this.functions[0].getFactory();
        DSCompiler compiler = factory.getCompiler();
        int n = this.functions.length;
        MathUtils.checkDimension(n, this.functions[0].getFreeParameters());
        int[] indirection = new int[n];
        int linearIndex = 0;
        int k = 1;
        while (linearIndex < n) {
            if (compiler.getPartialDerivativeOrdersSum(k) == 1) {
                indirection[linearIndex++] = k;
            }
            ++k;
        }
        RealMatrix linear = MatrixUtils.createRealMatrix(n, n);
        TaylorMap nonLinearTM = new TaylorMap(n, n);
        for (int i = 0; i < n; ++i) {
            nonLinearTM.functions[i] = factory.build(this.functions[i].getAllDerivatives());
            nonLinearTM.functions[i].setDerivativeComponent(0, 0.0);
            for (int j = 0; j < n; ++j) {
                int k2 = indirection[j];
                linear.setEntry(i, j, this.functions[i].getDerivativeComponent(k2));
                nonLinearTM.functions[i].setDerivativeComponent(k2, 0.0);
            }
        }
        RealMatrix linearInvert = decomposer.decompose(linear).getInverse();
        TaylorMap linearInvertTM = new TaylorMap(n, n);
        for (int i = 0; i < n; ++i) {
            linearInvertTM.functions[i] = new DerivativeStructure(factory);
            for (int j = 0; j < n; ++j) {
                linearInvertTM.functions[i].setDerivativeComponent(indirection[j], linearInvert.getEntry(i, j));
            }
        }
        TaylorMap identity = new TaylorMap(n, compiler.getOrder(), n);
        TaylorMap invertTM = linearInvertTM;
        for (int k3 = 1; k3 < compiler.getOrder(); ++k3) {
            invertTM = linearInvertTM.compose(identity.subtract(nonLinearTM.compose(invertTM)));
        }
        for (int i = 0; i < n; ++i) {
            invertTM.point[i] = this.functions[i].getValue();
            invertTM.functions[i].setDerivativeComponent(0, this.point[i]);
        }
        return invertTM;
    }
}

