/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.function;

import org.hipparchus.analysis.ParametricUnivariateFunction;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;

public class HarmonicOscillator
implements UnivariateDifferentiableFunction {
    private final double amplitude;
    private final double omega;
    private final double phase;

    public HarmonicOscillator(double amplitude, double omega, double phase) {
        this.amplitude = amplitude;
        this.omega = omega;
        this.phase = phase;
    }

    @Override
    public double value(double x) {
        return HarmonicOscillator.value(this.omega * x + this.phase, this.amplitude);
    }

    private static double value(double xTimesOmegaPlusPhase, double amplitude) {
        return amplitude * FastMath.cos(xTimesOmegaPlusPhase);
    }

    @Override
    public <T extends Derivative<T>> T value(T t) throws MathIllegalArgumentException {
        double x = t.getValue();
        double[] f = new double[t.getOrder() + 1];
        double alpha = this.omega * x + this.phase;
        SinCos scAlpha = FastMath.sinCos(alpha);
        f[0] = this.amplitude * scAlpha.cos();
        if (f.length > 1) {
            f[1] = -this.amplitude * this.omega * scAlpha.sin();
            double mo2 = -this.omega * this.omega;
            for (int i = 2; i < f.length; ++i) {
                f[i] = mo2 * f[i - 2];
            }
        }
        return (T)((Derivative)t.compose(f));
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double value(double x, double ... param) throws MathIllegalArgumentException, NullArgumentException {
            this.validateParameters(param);
            return HarmonicOscillator.value(x * param[1] + param[2], param[0]);
        }

        @Override
        public double[] gradient(double x, double ... param) throws MathIllegalArgumentException, NullArgumentException {
            this.validateParameters(param);
            double amplitude = param[0];
            double omega = param[1];
            double phase = param[2];
            double xTimesOmegaPlusPhase = omega * x + phase;
            double a = HarmonicOscillator.value(xTimesOmegaPlusPhase, 1.0);
            double p = -amplitude * FastMath.sin(xTimesOmegaPlusPhase);
            double w = p * x;
            return new double[]{a, w, p};
        }

        private void validateParameters(double[] param) throws MathIllegalArgumentException, NullArgumentException {
            MathUtils.checkNotNull(param);
            MathUtils.checkDimension(param.length, 3);
        }
    }
}

