/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.integration.UnivariateIntegrator;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.MathUtils;

public abstract class BaseAbstractUnivariateIntegrator
implements UnivariateIntegrator {
    public static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-15;
    public static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-6;
    public static final int DEFAULT_MIN_ITERATIONS_COUNT = 3;
    public static final int DEFAULT_MAX_ITERATIONS_COUNT = Integer.MAX_VALUE;
    protected final Incrementor iterations;
    private final double absoluteAccuracy;
    private final double relativeAccuracy;
    private final int minimalIterationCount;
    private Incrementor evaluations;
    private UnivariateFunction function;
    private double min;
    private double max;

    protected BaseAbstractUnivariateIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        this.relativeAccuracy = relativeAccuracy;
        this.absoluteAccuracy = absoluteAccuracy;
        if (minimalIterationCount <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, minimalIterationCount, 0);
        }
        if (maximalIterationCount <= minimalIterationCount) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, maximalIterationCount, minimalIterationCount);
        }
        this.minimalIterationCount = minimalIterationCount;
        this.iterations = new Incrementor(maximalIterationCount);
        this.evaluations = new Incrementor();
    }

    protected BaseAbstractUnivariateIntegrator(double relativeAccuracy, double absoluteAccuracy) {
        this(relativeAccuracy, absoluteAccuracy, 3, Integer.MAX_VALUE);
    }

    protected BaseAbstractUnivariateIntegrator(int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        this(1.0E-6, 1.0E-15, minimalIterationCount, maximalIterationCount);
    }

    @Override
    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public int getMinimalIterationCount() {
        return this.minimalIterationCount;
    }

    @Override
    public int getMaximalIterationCount() {
        return this.iterations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public int getIterations() {
        return this.iterations.getCount();
    }

    protected double getMin() {
        return this.min;
    }

    protected double getMax() {
        return this.max;
    }

    protected double computeObjectiveValue(double point) throws MathIllegalStateException {
        this.evaluations.increment();
        return this.function.value(point);
    }

    protected void setup(int maxEval, UnivariateFunction f, double lower, double upper) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(f);
        UnivariateSolverUtils.verifyInterval(lower, upper);
        this.min = lower;
        this.max = upper;
        this.function = f;
        this.evaluations = this.evaluations.withMaximalCount(maxEval);
        this.iterations.reset();
    }

    @Override
    public double integrate(int maxEval, UnivariateFunction f, double lower, double upper) throws MathIllegalArgumentException, MathIllegalStateException, NullArgumentException {
        this.setup(maxEval, f, lower, upper);
        return this.doIntegrate();
    }

    protected abstract double doIntegrate() throws MathIllegalStateException;
}

