/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.BaseAbstractFieldUnivariateIntegrator;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;

public class FieldTrapezoidIntegrator<T extends CalculusFieldElement<T>>
extends BaseAbstractFieldUnivariateIntegrator<T> {
    public static final int TRAPEZOID_MAX_ITERATIONS_COUNT = 64;
    private T s;

    public FieldTrapezoidIntegrator(Field<T> field, double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 64);
        }
    }

    public FieldTrapezoidIntegrator(Field<T> field, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 64);
        }
    }

    public FieldTrapezoidIntegrator(Field<T> field) {
        super(field, 3, 64);
    }

    T stage(BaseAbstractFieldUnivariateIntegrator<T> baseIntegrator, int n) throws MathIllegalStateException {
        if (n == 0) {
            T max = baseIntegrator.getMax();
            T min = baseIntegrator.getMin();
            this.s = ((CalculusFieldElement)((CalculusFieldElement)max.subtract(min)).multiply(0.5)).multiply((CalculusFieldElement)baseIntegrator.computeObjectiveValue((CalculusFieldElement)min).add(baseIntegrator.computeObjectiveValue((CalculusFieldElement)max)));
            return this.s;
        }
        long np = 1L << n - 1;
        CalculusFieldElement sum = (CalculusFieldElement)this.getField().getZero();
        T max = baseIntegrator.getMax();
        CalculusFieldElement min = baseIntegrator.getMin();
        CalculusFieldElement spacing = (CalculusFieldElement)((CalculusFieldElement)max.subtract(min)).divide((double)np);
        CalculusFieldElement x = min.add((CalculusFieldElement)((CalculusFieldElement)spacing.multiply(0.5)));
        for (long i = 0L; i < np; ++i) {
            sum = sum.add(baseIntegrator.computeObjectiveValue(x));
            x = x.add(spacing);
        }
        this.s = (CalculusFieldElement)this.s.add((CalculusFieldElement)sum.multiply(spacing)).multiply(0.5);
        return this.s;
    }

    @Override
    protected T doIntegrate() throws MathIllegalArgumentException, MathIllegalStateException {
        T oldt = this.stage(this, 0);
        this.iterations.increment();
        while (true) {
            double rlimit;
            double delta;
            int i = this.iterations.getCount();
            T t = this.stage(this, i);
            if (i >= this.getMinimalIterationCount() && ((delta = FastMath.abs((CalculusFieldElement)t.subtract(oldt)).getReal()) <= (rlimit = ((CalculusFieldElement)((CalculusFieldElement)FastMath.abs(oldt).add(FastMath.abs(t))).multiply(0.5 * this.getRelativeAccuracy())).getReal()) || delta <= this.getAbsoluteAccuracy())) {
                return t;
            }
            oldt = t;
            this.iterations.increment();
        }
    }
}

