/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.polynomials;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldPolynomialFunctionLagrangeForm<T extends CalculusFieldElement<T>>
implements CalculusFieldUnivariateFunction<T> {
    private T[] coefficients;
    private final T[] x;
    private final T[] y;
    private boolean coefficientsComputed;

    public FieldPolynomialFunctionLagrangeForm(T[] x, T[] y) throws MathIllegalArgumentException {
        this.x = (CalculusFieldElement[])x.clone();
        this.y = (CalculusFieldElement[])y.clone();
        this.coefficientsComputed = false;
        MathArrays.checkEqualLength(x, y);
        if (x.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.WRONG_NUMBER_OF_POINTS, 2, x.length, true);
        }
        MathArrays.checkOrder(x, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true, (boolean)true);
    }

    @Override
    public T value(T z) {
        int nearest = 0;
        int n = this.x.length;
        CalculusFieldElement[] c = (CalculusFieldElement[])this.y.clone();
        CalculusFieldElement[] d = (CalculusFieldElement[])c.clone();
        double minDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double dist = FastMath.abs((CalculusFieldElement)z.subtract(this.x[i])).getReal();
            if (!(dist < minDist)) continue;
            nearest = i;
            minDist = dist;
        }
        CalculusFieldElement value = this.y[nearest];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                CalculusFieldElement tc = (CalculusFieldElement)this.x[j].subtract(z);
                CalculusFieldElement td = (CalculusFieldElement)this.x[i + j].subtract(z);
                CalculusFieldElement divider = (CalculusFieldElement)this.x[j].subtract(this.x[i + j]);
                CalculusFieldElement w = c[j + 1].subtract(d[j]).divide(divider);
                c[j] = tc.multiply(w);
                d[j] = td.multiply(w);
            }
            value = (double)nearest < 0.5 * (double)(n - i + 1) ? value.add((CalculusFieldElement)c[nearest]) : value.add((CalculusFieldElement)d[--nearest]);
        }
        return (T)value;
    }

    public int degree() {
        return this.x.length - 1;
    }

    public T[] getInterpolatingPoints() {
        return (CalculusFieldElement[])this.x.clone();
    }

    public T[] getInterpolatingValues() {
        return (CalculusFieldElement[])this.y.clone();
    }

    public T[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        return (CalculusFieldElement[])this.coefficients.clone();
    }

    protected void computeCoefficients() {
        int n = this.degree() + 1;
        Field field = this.x[0].getField();
        this.coefficients = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(n + 1));
        c[0] = (CalculusFieldElement)field.getOne();
        for (int i = 0; i < n; ++i) {
            for (int j = i; j > 0; --j) {
                c[j] = c[j - 1].subtract((CalculusFieldElement)c[j].multiply(this.x[i]));
            }
            c[0] = c[0].multiply((CalculusFieldElement)this.x[i].negate());
            c[i + 1] = (CalculusFieldElement)field.getOne();
        }
        CalculusFieldElement[] tc = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        for (int i = 0; i < n; ++i) {
            CalculusFieldElement d = (CalculusFieldElement)field.getOne();
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                d = d.multiply((CalculusFieldElement)this.x[i].subtract(this.x[j]));
            }
            CalculusFieldElement t = this.y[i].divide((CalculusFieldElement)d);
            tc[n - 1] = c[n];
            this.coefficients[n - 1] = this.coefficients[n - 1].add((CalculusFieldElement)t.multiply(tc[n - 1]));
            for (int j = n - 2; j >= 0; --j) {
                tc[j] = c[j + 1].add((CalculusFieldElement)tc[j + 1].multiply(this.x[i]));
                this.coefficients[j] = this.coefficients[j].add((CalculusFieldElement)t.multiply(tc[j]));
            }
        }
        this.coefficientsComputed = true;
    }
}

