/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.polynomials;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.FieldUnivariateFunction;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathUtils;

public class PolynomialFunctionNewtonForm
implements UnivariateDifferentiableFunction,
FieldUnivariateFunction {
    private double[] coefficients;
    private final double[] c;
    private final double[] a;
    private boolean coefficientsComputed;

    public PolynomialFunctionNewtonForm(double[] a, double[] c) throws MathIllegalArgumentException, NullArgumentException {
        PolynomialFunctionNewtonForm.verifyInputArray(a, c);
        this.a = new double[a.length];
        this.c = new double[c.length];
        System.arraycopy(a, 0, this.a, 0, a.length);
        System.arraycopy(c, 0, this.c, 0, c.length);
        this.coefficientsComputed = false;
    }

    @Override
    public double value(double z) {
        return PolynomialFunctionNewtonForm.evaluate(this.a, this.c, z);
    }

    @Override
    public <T extends Derivative<T>> T value(T t) {
        PolynomialFunctionNewtonForm.verifyInputArray(this.a, this.c);
        int n = this.c.length;
        Derivative value = (Derivative)((Derivative)t.getField().getZero()).add(this.a[n]);
        for (int i = n - 1; i >= 0; --i) {
            value = (Derivative)((Derivative)t.subtract(this.c[i])).multiply(value).add(this.a[i]);
        }
        return (T)value;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T value(T t) {
        PolynomialFunctionNewtonForm.verifyInputArray(this.a, this.c);
        int n = this.c.length;
        CalculusFieldElement value = (CalculusFieldElement)((CalculusFieldElement)t.getField().getZero()).add(this.a[n]);
        for (int i = n - 1; i >= 0; --i) {
            value = (CalculusFieldElement)((CalculusFieldElement)t.subtract((double)this.c[i])).multiply(value).add(this.a[i]);
        }
        return (T)value;
    }

    public int degree() {
        return this.c.length;
    }

    public double[] getNewtonCoefficients() {
        double[] out = new double[this.a.length];
        System.arraycopy(this.a, 0, out, 0, this.a.length);
        return out;
    }

    public double[] getCenters() {
        double[] out = new double[this.c.length];
        System.arraycopy(this.c, 0, out, 0, this.c.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] a, double[] c, double z) throws MathIllegalArgumentException, NullArgumentException {
        PolynomialFunctionNewtonForm.verifyInputArray(a, c);
        int n = c.length;
        double value = a[n];
        for (int i = n - 1; i >= 0; --i) {
            value = a[i] + (z - c[i]) * value;
        }
        return value;
    }

    protected void computeCoefficients() {
        int i;
        int n = this.degree();
        this.coefficients = new double[n + 1];
        for (i = 0; i <= n; ++i) {
            this.coefficients[i] = 0.0;
        }
        this.coefficients[0] = this.a[n];
        for (i = n - 1; i >= 0; --i) {
            for (int j = n - i; j > 0; --j) {
                this.coefficients[j] = this.coefficients[j - 1] - this.c[i] * this.coefficients[j];
            }
            this.coefficients[0] = this.a[i] - this.c[i] * this.coefficients[0];
        }
        this.coefficientsComputed = true;
    }

    protected static void verifyInputArray(double[] a, double[] c) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(a);
        MathUtils.checkNotNull(c);
        if (a.length == 0 || c.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY, new Object[0]);
        }
        if (a.length != c.length + 1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ARRAY_SIZES_SHOULD_HAVE_DIFFERENCE_1, a.length, c.length);
        }
    }
}

