/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.solvers;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BaseUnivariateSolver;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.FastMath;

public interface BracketedUnivariateSolver<F extends UnivariateFunction>
extends BaseUnivariateSolver<F> {
    public double solve(int var1, F var2, double var3, double var5, AllowedSolution var7);

    public double solve(int var1, F var2, double var3, double var5, double var7, AllowedSolution var9);

    default public Interval solveInterval(int maxEval, F f, double min, double max) throws MathIllegalArgumentException, MathIllegalStateException {
        return this.solveInterval(maxEval, f, min, max, min + 0.5 * (max - min));
    }

    public Interval solveInterval(int var1, F var2, double var3, double var5, double var7) throws MathIllegalArgumentException, MathIllegalStateException;

    public static class Interval {
        private final double leftAbscissa;
        private final double leftValue;
        private final double rightAbscissa;
        private final double rightValue;

        public Interval(double leftAbscissa, double leftValue, double rightAbscissa, double rightValue) {
            this.leftAbscissa = leftAbscissa;
            this.leftValue = leftValue;
            this.rightAbscissa = rightAbscissa;
            this.rightValue = rightValue;
        }

        public double getLeftAbscissa() {
            return this.leftAbscissa;
        }

        public double getRightAbscissa() {
            return this.rightAbscissa;
        }

        public double getLeftValue() {
            return this.leftValue;
        }

        public double getRightValue() {
            return this.rightValue;
        }

        public double getSide(AllowedSolution allowed) {
            double xA = this.getLeftAbscissa();
            double yA = this.getLeftValue();
            double xB = this.getRightAbscissa();
            switch (allowed) {
                case ANY_SIDE: {
                    double absYA = FastMath.abs(this.getLeftValue());
                    double absYB = FastMath.abs(this.getRightValue());
                    return absYA < absYB ? xA : xB;
                }
                case LEFT_SIDE: {
                    return xA;
                }
                case RIGHT_SIDE: {
                    return xB;
                }
                case BELOW_SIDE: {
                    return yA <= 0.0 ? xA : xB;
                }
                case ABOVE_SIDE: {
                    return yA < 0.0 ? xB : xA;
                }
            }
            throw MathRuntimeException.createInternalError();
        }
    }
}

