/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.complex;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.FieldComplex;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;

public class ComplexUtils {
    private ComplexUtils() {
    }

    public static Complex polar2Complex(double r, double theta) throws MathIllegalArgumentException {
        if (r < 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NEGATIVE_COMPLEX_MODULE, r);
        }
        SinCos sc = FastMath.sinCos(theta);
        return new Complex(r * sc.cos(), r * sc.sin());
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> polar2Complex(T r, T theta) throws MathIllegalArgumentException {
        if (r.getReal() < 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NEGATIVE_COMPLEX_MODULE, r);
        }
        FieldSinCos<T> sc = FastMath.sinCos(theta);
        return new FieldComplex<T>(r.multiply(sc.cos()), r.multiply(sc.sin()));
    }

    public static Complex[] convertToComplex(double[] real) {
        Complex[] c = new Complex[real.length];
        for (int i = 0; i < real.length; ++i) {
            c[i] = new Complex(real[i], 0.0);
        }
        return c;
    }
}

