/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.complex;

import java.io.Serializable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;

public class RootsOfUnity
implements Serializable {
    private static final long serialVersionUID = 20120201L;
    private int omegaCount = 0;
    private double[] omegaReal = null;
    private double[] omegaImaginaryCounterClockwise = null;
    private double[] omegaImaginaryClockwise = null;
    private boolean isCounterClockWise = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCounterClockWise() throws MathIllegalStateException {
        RootsOfUnity rootsOfUnity = this;
        synchronized (rootsOfUnity) {
            if (this.omegaCount == 0) {
                throw new MathIllegalStateException(LocalizedCoreFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            return this.isCounterClockWise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeRoots(int n) throws MathIllegalArgumentException {
        if (n == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.CANNOT_COMPUTE_0TH_ROOT_OF_UNITY, new Object[0]);
        }
        RootsOfUnity rootsOfUnity = this;
        synchronized (rootsOfUnity) {
            this.isCounterClockWise = n > 0;
            int absN = FastMath.abs(n);
            if (absN == this.omegaCount) {
                return;
            }
            double t = Math.PI * 2 / (double)absN;
            SinCos sc = FastMath.sinCos(t);
            this.omegaReal = new double[absN];
            this.omegaImaginaryCounterClockwise = new double[absN];
            this.omegaImaginaryClockwise = new double[absN];
            this.omegaReal[0] = 1.0;
            this.omegaImaginaryCounterClockwise[0] = 0.0;
            this.omegaImaginaryClockwise[0] = 0.0;
            for (int i = 1; i < absN; ++i) {
                this.omegaReal[i] = this.omegaReal[i - 1] * sc.cos() - this.omegaImaginaryCounterClockwise[i - 1] * sc.sin();
                this.omegaImaginaryCounterClockwise[i] = this.omegaReal[i - 1] * sc.sin() + this.omegaImaginaryCounterClockwise[i - 1] * sc.cos();
                this.omegaImaginaryClockwise[i] = -this.omegaImaginaryCounterClockwise[i];
            }
            this.omegaCount = absN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getReal(int k) throws MathIllegalArgumentException, MathIllegalStateException {
        RootsOfUnity rootsOfUnity = this;
        synchronized (rootsOfUnity) {
            if (this.omegaCount == 0) {
                throw new MathIllegalStateException(LocalizedCoreFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            if (k < 0 || k >= this.omegaCount) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, k, 0, this.omegaCount - 1);
            }
            return this.omegaReal[k];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getImaginary(int k) throws MathIllegalArgumentException, MathIllegalStateException {
        RootsOfUnity rootsOfUnity = this;
        synchronized (rootsOfUnity) {
            if (this.omegaCount == 0) {
                throw new MathIllegalStateException(LocalizedCoreFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            if (k < 0 || k >= this.omegaCount) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, k, 0, this.omegaCount - 1);
            }
            return this.isCounterClockWise ? this.omegaImaginaryCounterClockwise[k] : this.omegaImaginaryClockwise[k];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRoots() {
        RootsOfUnity rootsOfUnity = this;
        synchronized (rootsOfUnity) {
            return this.omegaCount;
        }
    }
}

