/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.special.Beta;
import org.hipparchus.special.Gamma;
import org.hipparchus.util.FastMath;

public class TDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20160320L;
    private final double degreesOfFreedom;
    private final double factor;

    public TDistribution(double degreesOfFreedom) throws MathIllegalArgumentException {
        this(degreesOfFreedom, 1.0E-9);
    }

    public TDistribution(double degreesOfFreedom, double inverseCumAccuracy) throws MathIllegalArgumentException {
        super(inverseCumAccuracy);
        if (degreesOfFreedom <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DEGREES_OF_FREEDOM, degreesOfFreedom);
        }
        this.degreesOfFreedom = degreesOfFreedom;
        double n = degreesOfFreedom;
        double nPlus1Over2 = (n + 1.0) / 2.0;
        this.factor = Gamma.logGamma(nPlus1Over2) - 0.5 * (FastMath.log(Math.PI) + FastMath.log(n)) - Gamma.logGamma(n / 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double density(double x) {
        return FastMath.exp(this.logDensity(x));
    }

    @Override
    public double logDensity(double x) {
        double n = this.degreesOfFreedom;
        double nPlus1Over2 = (n + 1.0) / 2.0;
        return this.factor - nPlus1Over2 * FastMath.log(1.0 + x * x / n);
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret;
        if (x == 0.0) {
            ret = 0.5;
        } else {
            double t = Beta.regularizedBeta(this.degreesOfFreedom / (this.degreesOfFreedom + x * x), 0.5 * this.degreesOfFreedom, 0.5);
            ret = x < 0.0 ? 0.5 * t : 1.0 - 0.5 * t;
        }
        return ret;
    }

    @Override
    public double getNumericalMean() {
        double df = this.getDegreesOfFreedom();
        if (df > 1.0) {
            return 0.0;
        }
        return Double.NaN;
    }

    @Override
    public double getNumericalVariance() {
        double df = this.getDegreesOfFreedom();
        if (df > 2.0) {
            return df / (df - 2.0);
        }
        if (df > 1.0 && df <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

