/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.exception;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hipparchus.exception.UTF8Control;

public interface Localizable
extends Serializable {
    public String getSourceString();

    public String getLocalizedString(Locale var1);

    default public String getLocalizedString(String baseName, String key, Locale locale) {
        try {
            String translated;
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, new UTF8Control());
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage()) && !(translated = bundle.getString(key)).isEmpty() && !translated.toLowerCase(locale).contains("missing translation")) {
                return translated;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.getSourceString();
    }
}

