/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.fraction.Fraction;
import org.hipparchus.linear.AnyMatrix;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.BlockFieldMatrix;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.DefaultFieldMatrixPreservingVisitor;
import org.hipparchus.linear.DependentVectorsHandler;
import org.hipparchus.linear.DiagonalMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealMatrixFormat;
import org.hipparchus.linear.RealVector;
import org.hipparchus.linear.SingularValueDecomposition;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;

public class MatrixUtils {
    public static final RealMatrixFormat DEFAULT_FORMAT = RealMatrixFormat.getRealMatrixFormat();
    public static final RealMatrixFormat OCTAVE_FORMAT = new RealMatrixFormat("[", "]", "", "", "; ", ", ");
    private static final double[] PADE_COEFFICIENTS_3 = new double[]{120.0, 60.0, 12.0, 1.0};
    private static final double[] PADE_COEFFICIENTS_5 = new double[]{30240.0, 15120.0, 3360.0, 420.0, 30.0, 1.0};
    private static final double[] PADE_COEFFICIENTS_7 = new double[]{1.729728E7, 8648640.0, 1995840.0, 277200.0, 25200.0, 1512.0, 56.0, 1.0};
    private static final double[] PADE_COEFFICIENTS_9 = new double[]{1.76432256E10, 8.8216128E9, 2.0756736E9, 3.027024E8, 3.027024E7, 2162160.0, 110880.0, 3960.0, 90.0, 1.0};
    private static final double[] PADE_COEFFICIENTS_13 = new double[]{6.476475253248E16, 3.238237626624E16, 7.7717703038976E15, 1.1873537964288E15, 1.29060195264E14, 1.05594705216E13, 6.704425728E11, 3.352212864E10, 1.32324192E9, 4.08408E7, 960960.0, 16380.0, 182.0, 1.0};

    private MatrixUtils() {
    }

    public static RealMatrix createRealMatrix(int rows, int columns) {
        return rows * columns <= 4096 ? new Array2DRowRealMatrix(rows, columns) : new BlockRealMatrix(rows, columns);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(Field<T> field, int rows, int columns) {
        return rows * columns <= 4096 ? new Array2DRowFieldMatrix<T>(field, rows, columns) : new BlockFieldMatrix<T>(field, rows, columns);
    }

    public static RealMatrix createRealMatrix(double[][] data) throws MathIllegalArgumentException, NullArgumentException {
        if (data == null || data[0] == null) {
            throw new NullArgumentException();
        }
        return data.length * data[0].length <= 4096 ? new Array2DRowRealMatrix(data) : new BlockRealMatrix(data);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(T[][] data) throws MathIllegalArgumentException, NullArgumentException {
        if (data == null || data[0] == null) {
            throw new NullArgumentException();
        }
        return data.length * data[0].length <= 4096 ? new Array2DRowFieldMatrix(data) : new BlockFieldMatrix(data);
    }

    public static RealMatrix createRealIdentityMatrix(int dimension) {
        RealMatrix m = MatrixUtils.createRealMatrix(dimension, dimension);
        for (int i = 0; i < dimension; ++i) {
            m.setEntry(i, i, 1.0);
        }
        return m;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldIdentityMatrix(Field<T> field, int dimension) {
        T zero = field.getZero();
        T one = field.getOne();
        FieldElement[][] d = MathArrays.buildArray(field, (int)dimension, (int)dimension);
        for (int row = 0; row < dimension; ++row) {
            Object[] dRow = d[row];
            Arrays.fill(dRow, zero);
            dRow[row] = one;
        }
        return new Array2DRowFieldMatrix(field, d, false);
    }

    public static RealMatrix createRealDiagonalMatrix(double[] diagonal) {
        RealMatrix m = MatrixUtils.createRealMatrix(diagonal.length, diagonal.length);
        for (int i = 0; i < diagonal.length; ++i) {
            m.setEntry(i, i, diagonal[i]);
        }
        return m;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldDiagonalMatrix(T[] diagonal) {
        FieldMatrix<T> m = MatrixUtils.createFieldMatrix(diagonal[0].getField(), diagonal.length, diagonal.length);
        for (int i = 0; i < diagonal.length; ++i) {
            m.setEntry(i, i, diagonal[i]);
        }
        return m;
    }

    public static RealVector createRealVector(double[] data) throws MathIllegalArgumentException, NullArgumentException {
        if (data == null) {
            throw new NullArgumentException();
        }
        return new ArrayRealVector(data, true);
    }

    public static RealVector createRealVector(int dimension) {
        return new ArrayRealVector(new double[dimension]);
    }

    public static <T extends FieldElement<T>> FieldVector<T> createFieldVector(T[] data) throws MathIllegalArgumentException, NullArgumentException {
        if (data == null) {
            throw new NullArgumentException();
        }
        if (data.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        return new ArrayFieldVector(data[0].getField(), data, true);
    }

    public static <T extends FieldElement<T>> FieldVector<T> createFieldVector(Field<T> field, int dimension) {
        return new ArrayFieldVector(MathArrays.buildArray(field, (int)dimension));
    }

    public static RealMatrix createRowRealMatrix(double[] rowData) throws MathIllegalArgumentException, NullArgumentException {
        if (rowData == null) {
            throw new NullArgumentException();
        }
        int nCols = rowData.length;
        RealMatrix m = MatrixUtils.createRealMatrix(1, nCols);
        for (int i = 0; i < nCols; ++i) {
            m.setEntry(0, i, rowData[i]);
        }
        return m;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createRowFieldMatrix(T[] rowData) throws MathIllegalArgumentException, NullArgumentException {
        if (rowData == null) {
            throw new NullArgumentException();
        }
        int nCols = rowData.length;
        if (nCols == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        FieldMatrix<T> m = MatrixUtils.createFieldMatrix(rowData[0].getField(), 1, nCols);
        for (int i = 0; i < nCols; ++i) {
            m.setEntry(0, i, rowData[i]);
        }
        return m;
    }

    public static RealMatrix createColumnRealMatrix(double[] columnData) throws MathIllegalArgumentException, NullArgumentException {
        if (columnData == null) {
            throw new NullArgumentException();
        }
        int nRows = columnData.length;
        RealMatrix m = MatrixUtils.createRealMatrix(nRows, 1);
        for (int i = 0; i < nRows; ++i) {
            m.setEntry(i, 0, columnData[i]);
        }
        return m;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createColumnFieldMatrix(T[] columnData) throws MathIllegalArgumentException, NullArgumentException {
        if (columnData == null) {
            throw new NullArgumentException();
        }
        int nRows = columnData.length;
        if (nRows == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        FieldMatrix<T> m = MatrixUtils.createFieldMatrix(columnData[0].getField(), nRows, 1);
        for (int i = 0; i < nRows; ++i) {
            m.setEntry(i, 0, columnData[i]);
        }
        return m;
    }

    private static boolean isSymmetricInternal(RealMatrix matrix, double relativeTolerance, boolean raiseException) {
        int rows = matrix.getRowDimension();
        if (rows != matrix.getColumnDimension()) {
            if (raiseException) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, rows, matrix.getColumnDimension());
            }
            return false;
        }
        for (int i = 0; i < rows; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                double mji;
                double mij = matrix.getEntry(i, j);
                if (!(FastMath.abs(mij - (mji = matrix.getEntry(j, i))) > FastMath.max(FastMath.abs(mij), FastMath.abs(mji)) * relativeTolerance)) continue;
                if (raiseException) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SYMMETRIC_MATRIX, i, j, relativeTolerance);
                }
                return false;
            }
        }
        return true;
    }

    public static void checkSymmetric(RealMatrix matrix, double eps) {
        MatrixUtils.isSymmetricInternal(matrix, eps, true);
    }

    public static boolean isSymmetric(RealMatrix matrix, double eps) {
        return MatrixUtils.isSymmetricInternal(matrix, eps, false);
    }

    public static void checkMatrixIndex(AnyMatrix m, int row, int column) throws MathIllegalArgumentException {
        MatrixUtils.checkRowIndex(m, row);
        MatrixUtils.checkColumnIndex(m, column);
    }

    public static void checkRowIndex(AnyMatrix m, int row) throws MathIllegalArgumentException {
        if (row < 0 || row >= m.getRowDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ROW_INDEX, row, 0, m.getRowDimension() - 1);
        }
    }

    public static void checkColumnIndex(AnyMatrix m, int column) throws MathIllegalArgumentException {
        if (column < 0 || column >= m.getColumnDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.COLUMN_INDEX, column, 0, m.getColumnDimension() - 1);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix m, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        MatrixUtils.checkRowIndex(m, startRow);
        MatrixUtils.checkRowIndex(m, endRow);
        if (endRow < startRow) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INITIAL_ROW_AFTER_FINAL_ROW, endRow, startRow, false);
        }
        MatrixUtils.checkColumnIndex(m, startColumn);
        MatrixUtils.checkColumnIndex(m, endColumn);
        if (endColumn < startColumn) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, endColumn, startColumn, false);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix m, int[] selectedRows, int[] selectedColumns) throws MathIllegalArgumentException, NullArgumentException {
        if (selectedRows == null) {
            throw new NullArgumentException();
        }
        if (selectedColumns == null) {
            throw new NullArgumentException();
        }
        if (selectedRows.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EMPTY_SELECTED_ROW_INDEX_ARRAY, new Object[0]);
        }
        if (selectedColumns.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EMPTY_SELECTED_COLUMN_INDEX_ARRAY, new Object[0]);
        }
        for (int row : selectedRows) {
            MatrixUtils.checkRowIndex(m, row);
        }
        for (int column : selectedColumns) {
            MatrixUtils.checkColumnIndex(m, column);
        }
    }

    public static void checkAdditionCompatible(AnyMatrix left, AnyMatrix right) throws MathIllegalArgumentException {
        if (left.getRowDimension() != right.getRowDimension() || left.getColumnDimension() != right.getColumnDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, left.getRowDimension(), left.getColumnDimension(), right.getRowDimension(), right.getColumnDimension());
        }
    }

    public static void checkSubtractionCompatible(AnyMatrix left, AnyMatrix right) throws MathIllegalArgumentException {
        if (left.getRowDimension() != right.getRowDimension() || left.getColumnDimension() != right.getColumnDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, left.getRowDimension(), left.getColumnDimension(), right.getRowDimension(), right.getColumnDimension());
        }
    }

    public static void checkMultiplicationCompatible(AnyMatrix left, AnyMatrix right) throws MathIllegalArgumentException {
        if (left.getColumnDimension() != right.getRowDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, left.getColumnDimension(), right.getRowDimension());
        }
    }

    public static void checkSameColumnDimension(AnyMatrix left, AnyMatrix right) throws MathIllegalArgumentException {
        if (left.getColumnDimension() != right.getColumnDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, left.getColumnDimension(), right.getColumnDimension());
        }
    }

    public static void checkSameRowDimension(AnyMatrix left, AnyMatrix right) throws MathIllegalArgumentException {
        if (left.getRowDimension() != right.getRowDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, left.getRowDimension(), right.getRowDimension());
        }
    }

    public static Array2DRowRealMatrix fractionMatrixToRealMatrix(FieldMatrix<Fraction> m) {
        FractionMatrixConverter converter = new FractionMatrixConverter();
        m.walkInOptimizedOrder(converter);
        return converter.getConvertedMatrix();
    }

    public static Array2DRowRealMatrix bigFractionMatrixToRealMatrix(FieldMatrix<BigFraction> m) {
        BigFractionMatrixConverter converter = new BigFractionMatrixConverter();
        m.walkInOptimizedOrder(converter);
        return converter.getConvertedMatrix();
    }

    public static void solveLowerTriangularSystem(RealMatrix rm, RealVector b) throws MathIllegalArgumentException, MathRuntimeException {
        if (rm == null || b == null || rm.getRowDimension() != b.getDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, rm == null ? 0 : rm.getRowDimension(), b == null ? 0 : b.getDimension());
        }
        if (rm.getColumnDimension() != rm.getRowDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, rm.getRowDimension(), rm.getColumnDimension());
        }
        int rows = rm.getRowDimension();
        for (int i = 0; i < rows; ++i) {
            double diag = rm.getEntry(i, i);
            if (FastMath.abs(diag) < Precision.SAFE_MIN) {
                throw new MathRuntimeException(LocalizedCoreFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            double bi = b.getEntry(i) / diag;
            b.setEntry(i, bi);
            for (int j = i + 1; j < rows; ++j) {
                b.setEntry(j, b.getEntry(j) - bi * rm.getEntry(j, i));
            }
        }
    }

    public static void solveUpperTriangularSystem(RealMatrix rm, RealVector b) throws MathIllegalArgumentException, MathRuntimeException {
        if (rm == null || b == null || rm.getRowDimension() != b.getDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, rm == null ? 0 : rm.getRowDimension(), b == null ? 0 : b.getDimension());
        }
        if (rm.getColumnDimension() != rm.getRowDimension()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, rm.getRowDimension(), rm.getColumnDimension());
        }
        int rows = rm.getRowDimension();
        for (int i = rows - 1; i > -1; --i) {
            double diag = rm.getEntry(i, i);
            if (FastMath.abs(diag) < Precision.SAFE_MIN) {
                throw new MathRuntimeException(LocalizedCoreFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            double bi = b.getEntry(i) / diag;
            b.setEntry(i, bi);
            for (int j = i - 1; j > -1; --j) {
                b.setEntry(j, b.getEntry(j) - bi * rm.getEntry(j, i));
            }
        }
    }

    public static RealMatrix blockInverse(RealMatrix m, int splitIndex) {
        int n = m.getRowDimension();
        if (m.getColumnDimension() != n) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, m.getRowDimension(), m.getColumnDimension());
        }
        int splitIndex1 = splitIndex + 1;
        RealMatrix a = m.getSubMatrix(0, splitIndex, 0, splitIndex);
        RealMatrix b = m.getSubMatrix(0, splitIndex, splitIndex1, n - 1);
        RealMatrix c = m.getSubMatrix(splitIndex1, n - 1, 0, splitIndex);
        RealMatrix d = m.getSubMatrix(splitIndex1, n - 1, splitIndex1, n - 1);
        SingularValueDecomposition aDec = new SingularValueDecomposition(a);
        DecompositionSolver aSolver = aDec.getSolver();
        if (!aSolver.isNonSingular()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
        }
        RealMatrix aInv = aSolver.getInverse();
        SingularValueDecomposition dDec = new SingularValueDecomposition(d);
        DecompositionSolver dSolver = dDec.getSolver();
        if (!dSolver.isNonSingular()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
        }
        RealMatrix dInv = dSolver.getInverse();
        RealMatrix tmp1 = a.subtract(b.multiply(dInv).multiply(c));
        SingularValueDecomposition tmp1Dec = new SingularValueDecomposition(tmp1);
        DecompositionSolver tmp1Solver = tmp1Dec.getSolver();
        if (!tmp1Solver.isNonSingular()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
        }
        RealMatrix result00 = tmp1Solver.getInverse();
        RealMatrix tmp2 = d.subtract(c.multiply(aInv).multiply(b));
        SingularValueDecomposition tmp2Dec = new SingularValueDecomposition(tmp2);
        DecompositionSolver tmp2Solver = tmp2Dec.getSolver();
        if (!tmp2Solver.isNonSingular()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
        }
        RealMatrix result11 = tmp2Solver.getInverse();
        RealMatrix result01 = aInv.multiply(b).multiply(result11).scalarMultiply(-1.0);
        RealMatrix result10 = dInv.multiply(c).multiply(result00).scalarMultiply(-1.0);
        Array2DRowRealMatrix result = new Array2DRowRealMatrix(n, n);
        result.setSubMatrix(result00.getData(), 0, 0);
        result.setSubMatrix(result01.getData(), 0, splitIndex1);
        result.setSubMatrix(result10.getData(), splitIndex1, 0);
        result.setSubMatrix(result11.getData(), splitIndex1, splitIndex1);
        return result;
    }

    public static RealMatrix inverse(RealMatrix matrix) throws MathIllegalArgumentException, NullArgumentException {
        return MatrixUtils.inverse(matrix, 0.0);
    }

    public static RealMatrix inverse(RealMatrix matrix, double threshold) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(matrix);
        if (!matrix.isSquare()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, matrix.getRowDimension(), matrix.getColumnDimension());
        }
        if (matrix instanceof DiagonalMatrix) {
            return ((DiagonalMatrix)matrix).inverse(threshold);
        }
        QRDecomposition decomposition = new QRDecomposition(matrix, threshold);
        return decomposition.getSolver().getInverse();
    }

    public static RealMatrix matrixExponential(RealMatrix rm) {
        double[] padeCoefficients;
        if (!rm.isSquare()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, rm.getRowDimension(), rm.getColumnDimension());
        }
        int dim = rm.getRowDimension();
        RealMatrix identity = MatrixUtils.createRealIdentityMatrix(dim);
        RealMatrix scaledMatrix = rm.copy();
        double l1Norm = rm.getNorm1();
        int squaringCount = 0;
        if (l1Norm < 0.01495585217958292) {
            padeCoefficients = PADE_COEFFICIENTS_3;
        } else if (l1Norm < 0.253939833006323) {
            padeCoefficients = PADE_COEFFICIENTS_5;
        } else if (l1Norm < 0.9504178996162932) {
            padeCoefficients = PADE_COEFFICIENTS_7;
        } else if (l1Norm < 2.097847961257068) {
            padeCoefficients = PADE_COEFFICIENTS_9;
        } else {
            padeCoefficients = PADE_COEFFICIENTS_13;
            double normScale = 5.371920351148152;
            int finalSquaringCount = squaringCount = FastMath.max(0, FastMath.getExponent(l1Norm / 5.371920351148152));
            scaledMatrix.mapToSelf(x -> FastMath.scalb(x, -finalSquaringCount));
        }
        RealMatrix scaledMatrix2 = scaledMatrix.multiply(scaledMatrix);
        int coeffLength = padeCoefficients.length;
        RealMatrix padeV = MatrixUtils.createRealMatrix(dim, dim);
        for (int i = coeffLength - 1; i > 1; i -= 2) {
            padeV = scaledMatrix2.multiply(padeV.add(identity.scalarMultiply(padeCoefficients[i])));
        }
        padeV = scaledMatrix.multiply(padeV.add(identity.scalarMultiply(padeCoefficients[1])));
        RealMatrix padeU = MatrixUtils.createRealMatrix(dim, dim);
        for (int i = coeffLength - 2; i > 1; i -= 2) {
            padeU = scaledMatrix2.multiply(padeU.add(identity.scalarMultiply(padeCoefficients[i])));
        }
        padeU = padeU.add(identity.scalarMultiply(padeCoefficients[0]));
        RealMatrix padeNumer = padeU.add(padeV);
        RealMatrix padeDenom = padeU.subtract(padeV);
        QRDecomposition decomposition = new QRDecomposition(padeDenom);
        RealMatrix result = decomposition.getSolver().solve(padeNumer);
        for (int i = 0; i < squaringCount; ++i) {
            result = result.multiply(result);
        }
        return result;
    }

    public static List<RealVector> orthonormalize(List<RealVector> independent, double threshold, DependentVectorsHandler handler) {
        ArrayList<RealVector> basis = new ArrayList<RealVector>(independent);
        int index = 0;
        while (index < basis.size()) {
            RealVector vi = (RealVector)basis.get(index);
            double norm = vi.getNorm();
            if (norm <= threshold) {
                index = handler.manageDependent(index, basis);
                continue;
            }
            vi.mapDivideToSelf(vi.getNorm());
            for (int j = index + 1; j < basis.size(); ++j) {
                RealVector vj = (RealVector)basis.get(j);
                double dot = vi.dotProduct(vj);
                for (int k = 0; k < vj.getDimension(); ++k) {
                    vj.setEntry(k, vj.getEntry(k) - dot * vi.getEntry(k));
                }
            }
            ++index;
        }
        return basis;
    }

    public static <T extends CalculusFieldElement<T>> List<FieldVector<T>> orthonormalize(Field<T> field, List<FieldVector<T>> independent, T threshold, DependentVectorsHandler handler) {
        ArrayList<FieldVector<T>> basis = new ArrayList<FieldVector<T>>(independent);
        int index = 0;
        while (index < basis.size()) {
            FieldVector vi = (FieldVector)basis.get(index);
            CalculusFieldElement norm = (CalculusFieldElement)((CalculusFieldElement)vi.dotProduct(vi)).sqrt();
            if (norm.subtract(threshold).getReal() <= 0.0) {
                index = handler.manageDependent(field, index, basis);
                continue;
            }
            vi.mapDivideToSelf(norm);
            for (int j = index + 1; j < basis.size(); ++j) {
                FieldVector vj = (FieldVector)basis.get(j);
                CalculusFieldElement dot = (CalculusFieldElement)vi.dotProduct(vj);
                for (int k = 0; k < vj.getDimension(); ++k) {
                    vj.setEntry(k, ((CalculusFieldElement)vj.getEntry(k)).subtract(dot.multiply((CalculusFieldElement)vi.getEntry(k))));
                }
            }
            ++index;
        }
        return basis;
    }

    private static class BigFractionMatrixConverter
    extends DefaultFieldMatrixPreservingVisitor<BigFraction> {
        private double[][] data;

        BigFractionMatrixConverter() {
            super(BigFraction.ZERO);
        }

        @Override
        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            this.data = new double[rows][columns];
        }

        @Override
        public void visit(int row, int column, BigFraction value) {
            this.data[row][column] = value.doubleValue();
        }

        Array2DRowRealMatrix getConvertedMatrix() {
            return new Array2DRowRealMatrix(this.data, false);
        }
    }

    private static class FractionMatrixConverter
    extends DefaultFieldMatrixPreservingVisitor<Fraction> {
        private double[][] data;

        FractionMatrixConverter() {
            super(Fraction.ZERO);
        }

        @Override
        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            this.data = new double[rows][columns];
        }

        @Override
        public void visit(int row, int column, Fraction value) {
            this.data[row][column] = value.doubleValue();
        }

        Array2DRowRealMatrix getConvertedMatrix() {
            return new Array2DRowRealMatrix(this.data, false);
        }
    }
}

