/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.special.elliptic.carlson.RcRealDuplication;
import org.hipparchus.special.elliptic.carlson.RealDuplication;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

class RjRealDuplication
extends RealDuplication {
    private double delta;
    private double sM;

    RjRealDuplication(double x, double y, double z, double p, double delta) {
        super(x, y, z, p);
        this.delta = delta;
    }

    @Override
    protected void initialMeanPoint(double[] va) {
        va[4] = (va[0] + va[1] + va[2] + va[3] * 2.0) / 5.0;
    }

    @Override
    protected double convergenceCriterion(double r, double max) {
        return max / FastMath.sqrt(FastMath.sqrt(FastMath.sqrt(r * 0.25)));
    }

    @Override
    protected void update(int m, double[] vaM, double[] sqrtM, double fourM) {
        double dM = (sqrtM[3] + sqrtM[0]) * (sqrtM[3] + sqrtM[1]) * (sqrtM[3] + sqrtM[2]);
        if (m == 0) {
            this.sM = dM * 0.5;
        } else {
            double rM = this.sM * (FastMath.sqrt(this.delta / (this.sM * this.sM * fourM) + 1.0) + 1.0);
            this.sM = (dM * rM - this.delta / (fourM * fourM)) / ((dM + rM / fourM) * 2.0);
        }
        double lambdaA = sqrtM[0] * sqrtM[1];
        double lambdaB = sqrtM[0] * sqrtM[2];
        double lambdaC = sqrtM[1] * sqrtM[2];
        vaM[0] = MathArrays.linearCombination(0.25, vaM[0], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[1] = MathArrays.linearCombination(0.25, vaM[1], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[2] = MathArrays.linearCombination(0.25, vaM[2], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[3] = MathArrays.linearCombination(0.25, vaM[3], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[4] = MathArrays.linearCombination(0.25, vaM[4], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
    }

    @Override
    protected double evaluate(double[] va0, double aM, double fourM) {
        double inv = 1.0 / (aM * fourM);
        double bigX = (va0[4] - va0[0]) * inv;
        double bigY = (va0[4] - va0[1]) * inv;
        double bigZ = (va0[4] - va0[2]) * inv;
        double bigP = (bigX + bigY + bigZ) * -0.5;
        double bigP2 = bigP * bigP;
        double xyz = bigX * bigY * bigZ;
        double e2 = bigX * (bigY + bigZ) + bigY * bigZ - bigP * bigP * 3.0;
        double e3 = xyz + bigP * 2.0 * (e2 + bigP2 * 2.0);
        double e4 = (xyz * 2.0 + bigP * (e2 + bigP2 * 3.0)) * bigP;
        double e5 = xyz * bigP2;
        double e2e2 = e2 * e2;
        double e2e3 = e2 * e3;
        double e2e4 = e2 * e4;
        double e2e5 = e2 * e5;
        double e3e3 = e3 * e3;
        double e3e4 = e3 * e4;
        double e2e2e2 = e2e2 * e2;
        double e2e2e3 = e2e2 * e3;
        double poly = ((e3e4 + e2e5) * -540540.0 + e2e2e3 * 675675.0 + e2e4 * 612612.0 + e3e3 * 306306.0 + e2e2e2 * -255255.0 + e5 * 471240.0 + e2e3 * -706860.0 + e4 * -556920.0 + e2e2 * 417690.0 + e3 * 680680.0 + e2 * -875160.0 + 4084080.0) / 4084080.0;
        double polyTerm = poly / (aM * FastMath.sqrt(aM) * fourM);
        double rcTerm = new RcRealDuplication(1.0, this.delta / (this.sM * this.sM * fourM) + 1.0).integral() * 3.0 / this.sM;
        return polyTerm + rcTerm;
    }
}

