/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarD;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiEllipticBuilder;
import org.hipparchus.util.FastMath;

class FieldNegativeParameter<T extends CalculusFieldElement<T>>
extends FieldJacobiElliptic<T> {
    private final FieldJacobiElliptic<T> algorithm;
    private final T inputScale;
    private final T outputScale;

    FieldNegativeParameter(T m) {
        super(m);
        CalculusFieldElement omM = (CalculusFieldElement)((CalculusFieldElement)m.getField().getOne()).subtract(m);
        this.algorithm = JacobiEllipticBuilder.build(((CalculusFieldElement)m.negate()).divide(omM));
        this.inputScale = FastMath.sqrt(omM);
        this.outputScale = (CalculusFieldElement)this.inputScale.reciprocal();
    }

    @Override
    public FieldCopolarN<T> valuesN(T u) {
        FieldCopolarD<CalculusFieldElement> trioD = new FieldCopolarD<CalculusFieldElement>(this.algorithm.valuesN((CalculusFieldElement)u.multiply(this.inputScale)));
        return new FieldCopolarN<CalculusFieldElement>(this.outputScale.multiply((CalculusFieldElement)trioD.sd()), trioD.cd(), trioD.nd());
    }
}

