/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.Frequency;
import org.hipparchus.stat.descriptive.DescriptiveStatistics;
import org.hipparchus.stat.descriptive.UnivariateStatistic;
import org.hipparchus.stat.descriptive.moment.GeometricMean;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.Variance;
import org.hipparchus.stat.descriptive.rank.Max;
import org.hipparchus.stat.descriptive.rank.Min;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.hipparchus.stat.descriptive.summary.Product;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.hipparchus.stat.descriptive.summary.SumOfLogs;
import org.hipparchus.stat.descriptive.summary.SumOfSquares;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public final class StatUtils {
    private static final UnivariateStatistic SUM = new Sum();
    private static final UnivariateStatistic SUM_OF_SQUARES = new SumOfSquares();
    private static final UnivariateStatistic PRODUCT = new Product();
    private static final UnivariateStatistic SUM_OF_LOGS = new SumOfLogs();
    private static final UnivariateStatistic MIN = new Min();
    private static final UnivariateStatistic MAX = new Max();
    private static final UnivariateStatistic MEAN = new Mean();
    private static final Variance VARIANCE = new Variance();
    private static final Percentile PERCENTILE = new Percentile();
    private static final GeometricMean GEOMETRIC_MEAN = new GeometricMean();

    private StatUtils() {
    }

    public static double sum(double ... values) throws MathIllegalArgumentException {
        return SUM.evaluate(values);
    }

    public static double sum(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return SUM.evaluate(values, begin, length);
    }

    public static double sumSq(double ... values) throws MathIllegalArgumentException {
        return SUM_OF_SQUARES.evaluate(values);
    }

    public static double sumSq(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return SUM_OF_SQUARES.evaluate(values, begin, length);
    }

    public static double product(double ... values) throws MathIllegalArgumentException {
        return PRODUCT.evaluate(values);
    }

    public static double product(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return PRODUCT.evaluate(values, begin, length);
    }

    public static double sumLog(double ... values) throws MathIllegalArgumentException {
        return SUM_OF_LOGS.evaluate(values);
    }

    public static double sumLog(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return SUM_OF_LOGS.evaluate(values, begin, length);
    }

    public static double mean(double ... values) throws MathIllegalArgumentException {
        return MEAN.evaluate(values);
    }

    public static double mean(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return MEAN.evaluate(values, begin, length);
    }

    public static double geometricMean(double ... values) throws MathIllegalArgumentException {
        return GEOMETRIC_MEAN.evaluate(values);
    }

    public static double geometricMean(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return GEOMETRIC_MEAN.evaluate(values, begin, length);
    }

    public static double variance(double ... values) throws MathIllegalArgumentException {
        return VARIANCE.evaluate(values);
    }

    public static double variance(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return VARIANCE.evaluate(values, begin, length);
    }

    public static double variance(double[] values, double mean, int begin, int length) throws MathIllegalArgumentException {
        return VARIANCE.evaluate(values, mean, begin, length);
    }

    public static double variance(double[] values, double mean) throws MathIllegalArgumentException {
        return VARIANCE.evaluate(values, mean);
    }

    public static double populationVariance(double ... values) throws MathIllegalArgumentException {
        return new Variance(false).evaluate(values);
    }

    public static double populationVariance(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return new Variance(false).evaluate(values, begin, length);
    }

    public static double populationVariance(double[] values, double mean, int begin, int length) throws MathIllegalArgumentException {
        return new Variance(false).evaluate(values, mean, begin, length);
    }

    public static double populationVariance(double[] values, double mean) throws MathIllegalArgumentException {
        return new Variance(false).evaluate(values, mean);
    }

    public static double max(double ... values) throws MathIllegalArgumentException {
        return MAX.evaluate(values);
    }

    public static double max(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return MAX.evaluate(values, begin, length);
    }

    public static double min(double ... values) throws MathIllegalArgumentException {
        return MIN.evaluate(values);
    }

    public static double min(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return MIN.evaluate(values, begin, length);
    }

    public static double percentile(double[] values, double p) throws MathIllegalArgumentException {
        return PERCENTILE.evaluate(values, p);
    }

    public static double percentile(double[] values, int begin, int length, double p) throws MathIllegalArgumentException {
        return PERCENTILE.evaluate(values, begin, length, p);
    }

    public static double sumDifference(double[] sample1, double[] sample2) throws MathIllegalArgumentException {
        int n = sample1.length;
        MathArrays.checkEqualLength((double[])sample1, (double[])sample2);
        if (n <= 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INSUFFICIENT_DIMENSION, new Object[0]);
        }
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result += sample1[i] - sample2[i];
        }
        return result;
    }

    public static double meanDifference(double[] sample1, double[] sample2) throws MathIllegalArgumentException {
        return StatUtils.sumDifference(sample1, sample2) / (double)sample1.length;
    }

    public static double varianceDifference(double[] sample1, double[] sample2, double meanDifference) throws MathIllegalArgumentException {
        double sum1 = 0.0;
        double sum2 = 0.0;
        int n = sample1.length;
        MathArrays.checkEqualLength((double[])sample1, (double[])sample2);
        if (n < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, new Object[]{n, 2});
        }
        for (int i = 0; i < n; ++i) {
            double diff = sample1[i] - sample2[i];
            sum1 += (diff - meanDifference) * (diff - meanDifference);
            sum2 += diff - meanDifference;
        }
        return (sum1 - sum2 * sum2 / (double)n) / (double)(n - 1);
    }

    public static double[] normalize(double ... sample) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (double v : sample) {
            stats.addValue(v);
        }
        double mean = stats.getMean();
        double standardDeviation = stats.getStandardDeviation();
        double[] standardizedSample = new double[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            standardizedSample[i] = (sample[i] - mean) / standardDeviation;
        }
        return standardizedSample;
    }

    public static double[] mode(double ... sample) throws MathIllegalArgumentException {
        MathUtils.checkNotNull((Object)sample, (Localizable)LocalizedCoreFormats.INPUT_ARRAY, (Object[])new Object[0]);
        return StatUtils.getMode(sample, 0, sample.length);
    }

    public static double[] mode(double[] sample, int begin, int length) {
        MathUtils.checkNotNull((Object)sample, (Localizable)LocalizedCoreFormats.INPUT_ARRAY, (Object[])new Object[0]);
        if (begin < 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.START_POSITION, new Object[]{begin});
        }
        if (length < 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.LENGTH, new Object[]{length});
        }
        return StatUtils.getMode(sample, begin, length);
    }

    private static double[] getMode(double[] values, int begin, int length) {
        Frequency freq = new Frequency();
        Arrays.stream(values, begin, begin + length).filter(d -> !Double.isNaN(d)).forEach(freq::addValue);
        List list = freq.getMode();
        return list.stream().mapToDouble(Double::doubleValue).toArray();
    }
}

