/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import java.io.Serializable;
import java.text.NumberFormat;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.polynomials.SmoothStepFactory;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3DFormat;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldBlendable;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;

public class FieldVector3D<T extends CalculusFieldElement<T>>
implements FieldBlendable<FieldVector3D<T>, T>,
Serializable {
    private static final long serialVersionUID = 20130224L;
    private final T x;
    private final T y;
    private final T z;

    public FieldVector3D(T x, T y, T z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public FieldVector3D(T[] v) throws MathIllegalArgumentException {
        if (v.length != 3) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{v.length, 3});
        }
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
    }

    public FieldVector3D(T alpha, T delta) {
        FieldSinCos sinCosAlpha = FastMath.sinCos(alpha);
        FieldSinCos sinCosDelta = FastMath.sinCos(delta);
        this.x = (CalculusFieldElement)((CalculusFieldElement)sinCosAlpha.cos()).multiply((FieldElement)((CalculusFieldElement)sinCosDelta.cos()));
        this.y = (CalculusFieldElement)((CalculusFieldElement)sinCosAlpha.sin()).multiply((FieldElement)((CalculusFieldElement)sinCosDelta.cos()));
        this.z = (CalculusFieldElement)sinCosDelta.sin();
    }

    public FieldVector3D(T a, FieldVector3D<T> u) {
        this.x = (CalculusFieldElement)a.multiply(u.x);
        this.y = (CalculusFieldElement)a.multiply(u.y);
        this.z = (CalculusFieldElement)a.multiply(u.z);
    }

    public FieldVector3D(T a, Vector3D u) {
        this.x = (CalculusFieldElement)a.multiply(u.getX());
        this.y = (CalculusFieldElement)a.multiply(u.getY());
        this.z = (CalculusFieldElement)a.multiply(u.getZ());
    }

    public FieldVector3D(double a, FieldVector3D<T> u) {
        this.x = (CalculusFieldElement)u.x.multiply(a);
        this.y = (CalculusFieldElement)u.y.multiply(a);
        this.z = (CalculusFieldElement)u.z.multiply(a);
    }

    public FieldVector3D(T a1, FieldVector3D<T> u1, T a2, FieldVector3D<T> u2) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY());
        this.z = (CalculusFieldElement)prototype.linearCombination(a1, u1.getZ(), a2, u2.getZ());
    }

    public FieldVector3D(T a1, Vector3D u1, T a2, Vector3D u2) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(u1.getX(), a1, u2.getX(), a2);
        this.y = (CalculusFieldElement)prototype.linearCombination(u1.getY(), a1, u2.getY(), a2);
        this.z = (CalculusFieldElement)prototype.linearCombination(u1.getZ(), a1, u2.getZ(), a2);
    }

    public FieldVector3D(double a1, FieldVector3D<T> u1, double a2, FieldVector3D<T> u2) {
        T prototype = u1.getX();
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY());
        this.z = (CalculusFieldElement)prototype.linearCombination(a1, u1.getZ(), a2, u2.getZ());
    }

    public FieldVector3D(T a1, FieldVector3D<T> u1, T a2, FieldVector3D<T> u2, T a3, FieldVector3D<T> u3) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX(), a3, u3.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY(), a3, u3.getY());
        this.z = (CalculusFieldElement)prototype.linearCombination(a1, u1.getZ(), a2, u2.getZ(), a3, u3.getZ());
    }

    public FieldVector3D(T a1, Vector3D u1, T a2, Vector3D u2, T a3, Vector3D u3) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(u1.getX(), a1, u2.getX(), a2, u3.getX(), a3);
        this.y = (CalculusFieldElement)prototype.linearCombination(u1.getY(), a1, u2.getY(), a2, u3.getY(), a3);
        this.z = (CalculusFieldElement)prototype.linearCombination(u1.getZ(), a1, u2.getZ(), a2, u3.getZ(), a3);
    }

    public FieldVector3D(double a1, FieldVector3D<T> u1, double a2, FieldVector3D<T> u2, double a3, FieldVector3D<T> u3) {
        T prototype = u1.getX();
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX(), a3, u3.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY(), a3, u3.getY());
        this.z = (CalculusFieldElement)prototype.linearCombination(a1, u1.getZ(), a2, u2.getZ(), a3, u3.getZ());
    }

    public FieldVector3D(T a1, FieldVector3D<T> u1, T a2, FieldVector3D<T> u2, T a3, FieldVector3D<T> u3, T a4, FieldVector3D<T> u4) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX(), a3, u3.getX(), a4, u4.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY(), a3, u3.getY(), a4, u4.getY());
        this.z = (CalculusFieldElement)prototype.linearCombination(a1, u1.getZ(), a2, u2.getZ(), a3, u3.getZ(), a4, u4.getZ());
    }

    public FieldVector3D(T a1, Vector3D u1, T a2, Vector3D u2, T a3, Vector3D u3, T a4, Vector3D u4) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(u1.getX(), a1, u2.getX(), a2, u3.getX(), a3, u4.getX(), a4);
        this.y = (CalculusFieldElement)prototype.linearCombination(u1.getY(), a1, u2.getY(), a2, u3.getY(), a3, u4.getY(), a4);
        this.z = (CalculusFieldElement)prototype.linearCombination(u1.getZ(), a1, u2.getZ(), a2, u3.getZ(), a3, u4.getZ(), a4);
    }

    public FieldVector3D(double a1, FieldVector3D<T> u1, double a2, FieldVector3D<T> u2, double a3, FieldVector3D<T> u3, double a4, FieldVector3D<T> u4) {
        T prototype = u1.getX();
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX(), a3, u3.getX(), a4, u4.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY(), a3, u3.getY(), a4, u4.getY());
        this.z = (CalculusFieldElement)prototype.linearCombination(a1, u1.getZ(), a2, u2.getZ(), a3, u3.getZ(), a4, u4.getZ());
    }

    public FieldVector3D(Field<T> field, Vector3D v) {
        this.x = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(v.getX());
        this.y = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(v.getY());
        this.z = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(v.getZ());
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getZero(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.ZERO);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getPlusI(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.PLUS_I);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getMinusI(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.MINUS_I);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getPlusJ(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.PLUS_J);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getMinusJ(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.MINUS_J);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getPlusK(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.PLUS_K);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getMinusK(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.MINUS_K);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getNaN(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.NaN);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getPositiveInfinity(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.POSITIVE_INFINITY);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> getNegativeInfinity(Field<T> field) {
        return new FieldVector3D<T>(field, Vector3D.NEGATIVE_INFINITY);
    }

    public T getX() {
        return this.x;
    }

    public T getY() {
        return this.y;
    }

    public T getZ() {
        return this.z;
    }

    public T[] toArray() {
        CalculusFieldElement[] array = (CalculusFieldElement[])MathArrays.buildArray((Field)this.x.getField(), (int)3);
        array[0] = this.x;
        array[1] = this.y;
        array[2] = this.z;
        return array;
    }

    public Vector3D toVector3D() {
        return new Vector3D(this.x.getReal(), this.y.getReal(), this.z.getReal());
    }

    public T getNorm1() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.x.abs()).add((FieldElement)((CalculusFieldElement)this.y.abs()))).add((FieldElement)((CalculusFieldElement)this.z.abs())));
    }

    public T getNorm() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.x.square()).add((FieldElement)((CalculusFieldElement)this.y.square()))).add((FieldElement)((CalculusFieldElement)this.z.square()))).sqrt());
    }

    public T getNormSq() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.x.square()).add((FieldElement)((CalculusFieldElement)this.y.square()))).add((FieldElement)((CalculusFieldElement)this.z.square())));
    }

    public T getNormInf() {
        return (T)FastMath.max((CalculusFieldElement)FastMath.abs(this.x), (CalculusFieldElement)FastMath.max((CalculusFieldElement)FastMath.abs(this.y), (CalculusFieldElement)FastMath.abs(this.z)));
    }

    public T getAlpha() {
        return (T)((CalculusFieldElement)this.y.atan2(this.x));
    }

    public T getDelta() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.z.divide(this.getNorm())).asin());
    }

    public FieldVector3D<T> add(FieldVector3D<T> v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.add(v.x), (CalculusFieldElement)this.y.add(v.y), (CalculusFieldElement)this.z.add(v.z));
    }

    public FieldVector3D<T> add(Vector3D v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.add(v.getX()), (CalculusFieldElement)this.y.add(v.getY()), (CalculusFieldElement)this.z.add(v.getZ()));
    }

    public FieldVector3D<T> add(T factor, FieldVector3D<T> v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.getField().getOne(), (FieldVector3D<CalculusFieldElement>)this, (CalculusFieldElement)factor, (FieldVector3D<CalculusFieldElement>)v);
    }

    public FieldVector3D<T> add(T factor, Vector3D v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.add((FieldElement)((CalculusFieldElement)factor.multiply(v.getX()))), (CalculusFieldElement)this.y.add((FieldElement)((CalculusFieldElement)factor.multiply(v.getY()))), (CalculusFieldElement)this.z.add((FieldElement)((CalculusFieldElement)factor.multiply(v.getZ()))));
    }

    public FieldVector3D<T> add(double factor, FieldVector3D<T> v) {
        return new FieldVector3D<T>(1.0, this, factor, v);
    }

    public FieldVector3D<T> add(double factor, Vector3D v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.add(factor * v.getX()), (CalculusFieldElement)this.y.add(factor * v.getY()), (CalculusFieldElement)this.z.add(factor * v.getZ()));
    }

    public FieldVector3D<T> subtract(FieldVector3D<T> v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.subtract(v.x), (CalculusFieldElement)this.y.subtract(v.y), (CalculusFieldElement)this.z.subtract(v.z));
    }

    public FieldVector3D<T> subtract(Vector3D v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.subtract(v.getX()), (CalculusFieldElement)this.y.subtract(v.getY()), (CalculusFieldElement)this.z.subtract(v.getZ()));
    }

    public FieldVector3D<T> subtract(T factor, FieldVector3D<T> v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.getField().getOne(), this, (CalculusFieldElement)factor.negate(), v);
    }

    public FieldVector3D<T> subtract(T factor, Vector3D v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.subtract((FieldElement)((CalculusFieldElement)factor.multiply(v.getX()))), (CalculusFieldElement)this.y.subtract((FieldElement)((CalculusFieldElement)factor.multiply(v.getY()))), (CalculusFieldElement)this.z.subtract((FieldElement)((CalculusFieldElement)factor.multiply(v.getZ()))));
    }

    public FieldVector3D<T> subtract(double factor, FieldVector3D<T> v) {
        return new FieldVector3D<T>(1.0, this, -factor, v);
    }

    public FieldVector3D<T> subtract(double factor, Vector3D v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.subtract(factor * v.getX()), (CalculusFieldElement)this.y.subtract(factor * v.getY()), (CalculusFieldElement)this.z.subtract(factor * v.getZ()));
    }

    public FieldVector3D<T> normalize() throws MathRuntimeException {
        T s = this.getNorm();
        if (s.getReal() == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedGeometryFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply((CalculusFieldElement)s.reciprocal());
    }

    public FieldVector3D<T> orthogonal() throws MathRuntimeException {
        double threshold = 0.6 * this.getNorm().getReal();
        if (threshold == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        if (FastMath.abs((double)this.x.getReal()) <= threshold) {
            CalculusFieldElement inverse = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.y.square()).add((FieldElement)((CalculusFieldElement)this.z.square()))).sqrt()).reciprocal();
            return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)inverse.getField().getZero(), (CalculusFieldElement)inverse.multiply(this.z), (CalculusFieldElement)((CalculusFieldElement)inverse.multiply(this.y)).negate());
        }
        if (FastMath.abs((double)this.y.getReal()) <= threshold) {
            CalculusFieldElement inverse = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.x.square()).add((FieldElement)((CalculusFieldElement)this.z.square()))).sqrt()).reciprocal();
            return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)inverse.multiply(this.z)).negate(), (CalculusFieldElement)inverse.getField().getZero(), (CalculusFieldElement)inverse.multiply(this.x));
        }
        CalculusFieldElement inverse = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.x.square()).add((FieldElement)((CalculusFieldElement)this.y.square()))).sqrt()).reciprocal();
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)inverse.multiply(this.y), (CalculusFieldElement)((CalculusFieldElement)inverse.multiply(this.x)).negate(), (CalculusFieldElement)inverse.getField().getZero());
    }

    public static <T extends CalculusFieldElement<T>> T angle(FieldVector3D<T> v1, FieldVector3D<T> v2) throws MathRuntimeException {
        CalculusFieldElement normProduct = (CalculusFieldElement)v1.getNorm().multiply(v2.getNorm());
        if (normProduct.getReal() == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        T dot = FieldVector3D.dotProduct(v1, v2);
        double threshold = normProduct.getReal() * 0.9999;
        if (dot.getReal() < -threshold || dot.getReal() > threshold) {
            FieldVector3D<T> v3 = FieldVector3D.crossProduct(v1, v2);
            if (dot.getReal() >= 0.0) {
                return (T)((CalculusFieldElement)((CalculusFieldElement)v3.getNorm().divide((FieldElement)normProduct)).asin());
            }
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v3.getNorm().divide((FieldElement)normProduct)).asin()).subtract((FieldElement)((CalculusFieldElement)dot.getPi()))).negate());
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)dot.divide((FieldElement)normProduct)).acos());
    }

    public static <T extends CalculusFieldElement<T>> T angle(FieldVector3D<T> v1, Vector3D v2) throws MathRuntimeException {
        CalculusFieldElement normProduct = (CalculusFieldElement)v1.getNorm().multiply(v2.getNorm());
        if (normProduct.getReal() == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        T dot = FieldVector3D.dotProduct(v1, v2);
        double threshold = normProduct.getReal() * 0.9999;
        if (dot.getReal() < -threshold || dot.getReal() > threshold) {
            FieldVector3D<T> v3 = FieldVector3D.crossProduct(v1, v2);
            if (dot.getReal() >= 0.0) {
                return (T)((CalculusFieldElement)((CalculusFieldElement)v3.getNorm().divide((FieldElement)normProduct)).asin());
            }
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v3.getNorm().divide((FieldElement)normProduct)).asin()).subtract((FieldElement)((CalculusFieldElement)dot.getPi()))).negate());
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)dot.divide((FieldElement)normProduct)).acos());
    }

    public static <T extends CalculusFieldElement<T>> T angle(Vector3D v1, FieldVector3D<T> v2) throws MathRuntimeException {
        return FieldVector3D.angle(v2, v1);
    }

    public FieldVector3D<T> negate() {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.negate(), (CalculusFieldElement)this.y.negate(), (CalculusFieldElement)this.z.negate());
    }

    public FieldVector3D<T> scalarMultiply(T a) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.multiply(a), (CalculusFieldElement)this.y.multiply(a), (CalculusFieldElement)this.z.multiply(a));
    }

    public FieldVector3D<T> scalarMultiply(double a) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.multiply(a), (CalculusFieldElement)this.y.multiply(a), (CalculusFieldElement)this.z.multiply(a));
    }

    public boolean isNaN() {
        return Double.isNaN(this.x.getReal()) || Double.isNaN(this.y.getReal()) || Double.isNaN(this.z.getReal());
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.x.getReal()) || Double.isInfinite(this.y.getReal()) || Double.isInfinite(this.z.getReal()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FieldVector3D) {
            FieldVector3D rhs = (FieldVector3D)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return this.x.equals(rhs.x) && this.y.equals(rhs.y) && this.z.equals(rhs.z);
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 409;
        }
        return 311 * (107 * this.x.hashCode() + 83 * this.y.hashCode() + this.z.hashCode());
    }

    public T dotProduct(FieldVector3D<T> v) {
        return (T)((CalculusFieldElement)this.x.linearCombination(this.x, v.x, this.y, v.y, this.z, v.z));
    }

    public T dotProduct(Vector3D v) {
        return (T)((CalculusFieldElement)this.x.linearCombination(v.getX(), this.x, v.getY(), this.y, v.getZ(), this.z));
    }

    public FieldVector3D<T> crossProduct(FieldVector3D<T> v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.linearCombination(this.y, v.z, (FieldElement)((CalculusFieldElement)this.z.negate()), v.y), (CalculusFieldElement)this.y.linearCombination(this.z, v.x, (FieldElement)((CalculusFieldElement)this.x.negate()), v.z), (CalculusFieldElement)this.z.linearCombination(this.x, v.y, (FieldElement)((CalculusFieldElement)this.y.negate()), v.x));
    }

    public FieldVector3D<T> crossProduct(Vector3D v) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.x.linearCombination(v.getZ(), this.y, -v.getY(), this.z), (CalculusFieldElement)this.y.linearCombination(v.getX(), this.z, -v.getZ(), this.x), (CalculusFieldElement)this.z.linearCombination(v.getY(), this.x, -v.getX(), this.y));
    }

    public T distance1(FieldVector3D<T> v) {
        CalculusFieldElement dx = (CalculusFieldElement)((CalculusFieldElement)v.x.subtract(this.x)).abs();
        CalculusFieldElement dy = (CalculusFieldElement)((CalculusFieldElement)v.y.subtract(this.y)).abs();
        CalculusFieldElement dz = (CalculusFieldElement)((CalculusFieldElement)v.z.subtract(this.z)).abs();
        return (T)((CalculusFieldElement)((CalculusFieldElement)dx.add((FieldElement)dy)).add((FieldElement)dz));
    }

    public T distance1(Vector3D v) {
        CalculusFieldElement dx = (CalculusFieldElement)((CalculusFieldElement)this.x.subtract(v.getX())).abs();
        CalculusFieldElement dy = (CalculusFieldElement)((CalculusFieldElement)this.y.subtract(v.getY())).abs();
        CalculusFieldElement dz = (CalculusFieldElement)((CalculusFieldElement)this.z.subtract(v.getZ())).abs();
        return (T)((CalculusFieldElement)((CalculusFieldElement)dx.add((FieldElement)dy)).add((FieldElement)dz));
    }

    public T distance(FieldVector3D<T> v) {
        CalculusFieldElement dx = (CalculusFieldElement)v.x.subtract(this.x);
        CalculusFieldElement dy = (CalculusFieldElement)v.y.subtract(this.y);
        CalculusFieldElement dz = (CalculusFieldElement)v.z.subtract(this.z);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square()))).add((FieldElement)((CalculusFieldElement)dz.square()))).sqrt());
    }

    public T distance(Vector3D v) {
        CalculusFieldElement dx = (CalculusFieldElement)this.x.subtract(v.getX());
        CalculusFieldElement dy = (CalculusFieldElement)this.y.subtract(v.getY());
        CalculusFieldElement dz = (CalculusFieldElement)this.z.subtract(v.getZ());
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square()))).add((FieldElement)((CalculusFieldElement)dz.square()))).sqrt());
    }

    public T distanceInf(FieldVector3D<T> v) {
        CalculusFieldElement dx = (CalculusFieldElement)((CalculusFieldElement)v.x.subtract(this.x)).abs();
        CalculusFieldElement dy = (CalculusFieldElement)((CalculusFieldElement)v.y.subtract(this.y)).abs();
        CalculusFieldElement dz = (CalculusFieldElement)((CalculusFieldElement)v.z.subtract(this.z)).abs();
        if (dx.getReal() <= dy.getReal()) {
            if (dy.getReal() <= dz.getReal()) {
                return (T)dz;
            }
            return (T)dy;
        }
        if (dx.getReal() <= dz.getReal()) {
            return (T)dz;
        }
        return (T)dx;
    }

    public T distanceInf(Vector3D v) {
        CalculusFieldElement dx = (CalculusFieldElement)((CalculusFieldElement)this.x.subtract(v.getX())).abs();
        CalculusFieldElement dy = (CalculusFieldElement)((CalculusFieldElement)this.y.subtract(v.getY())).abs();
        CalculusFieldElement dz = (CalculusFieldElement)((CalculusFieldElement)this.z.subtract(v.getZ())).abs();
        if (dx.getReal() <= dy.getReal()) {
            if (dy.getReal() <= dz.getReal()) {
                return (T)dz;
            }
            return (T)dy;
        }
        if (dx.getReal() <= dz.getReal()) {
            return (T)dz;
        }
        return (T)dx;
    }

    public T distanceSq(FieldVector3D<T> v) {
        CalculusFieldElement dx = (CalculusFieldElement)v.x.subtract(this.x);
        CalculusFieldElement dy = (CalculusFieldElement)v.y.subtract(this.y);
        CalculusFieldElement dz = (CalculusFieldElement)v.z.subtract(this.z);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square()))).add((FieldElement)((CalculusFieldElement)dz.square())));
    }

    public T distanceSq(Vector3D v) {
        CalculusFieldElement dx = (CalculusFieldElement)this.x.subtract(v.getX());
        CalculusFieldElement dy = (CalculusFieldElement)this.y.subtract(v.getY());
        CalculusFieldElement dz = (CalculusFieldElement)this.z.subtract(v.getZ());
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square()))).add((FieldElement)((CalculusFieldElement)dz.square())));
    }

    public static <T extends CalculusFieldElement<T>> T dotProduct(FieldVector3D<T> v1, FieldVector3D<T> v2) {
        return v1.dotProduct(v2);
    }

    public static <T extends CalculusFieldElement<T>> T dotProduct(FieldVector3D<T> v1, Vector3D v2) {
        return v1.dotProduct(v2);
    }

    public static <T extends CalculusFieldElement<T>> T dotProduct(Vector3D v1, FieldVector3D<T> v2) {
        return v2.dotProduct(v1);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> crossProduct(FieldVector3D<T> v1, FieldVector3D<T> v2) {
        return v1.crossProduct(v2);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> crossProduct(FieldVector3D<T> v1, Vector3D v2) {
        return v1.crossProduct(v2);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> crossProduct(Vector3D v1, FieldVector3D<T> v2) {
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)v2.x.linearCombination(v1.getY(), v2.z, -v1.getZ(), v2.y), (CalculusFieldElement)v2.y.linearCombination(v1.getZ(), v2.x, -v1.getX(), v2.z), (CalculusFieldElement)v2.z.linearCombination(v1.getX(), v2.y, -v1.getY(), v2.x));
    }

    public static <T extends CalculusFieldElement<T>> T distance1(FieldVector3D<T> v1, FieldVector3D<T> v2) {
        return v1.distance1(v2);
    }

    public static <T extends CalculusFieldElement<T>> T distance1(FieldVector3D<T> v1, Vector3D v2) {
        return v1.distance1(v2);
    }

    public static <T extends CalculusFieldElement<T>> T distance1(Vector3D v1, FieldVector3D<T> v2) {
        return v2.distance1(v1);
    }

    public static <T extends CalculusFieldElement<T>> T distance(FieldVector3D<T> v1, FieldVector3D<T> v2) {
        return v1.distance(v2);
    }

    public static <T extends CalculusFieldElement<T>> T distance(FieldVector3D<T> v1, Vector3D v2) {
        return v1.distance(v2);
    }

    public static <T extends CalculusFieldElement<T>> T distance(Vector3D v1, FieldVector3D<T> v2) {
        return v2.distance(v1);
    }

    public static <T extends CalculusFieldElement<T>> T distanceInf(FieldVector3D<T> v1, FieldVector3D<T> v2) {
        return v1.distanceInf(v2);
    }

    public static <T extends CalculusFieldElement<T>> T distanceInf(FieldVector3D<T> v1, Vector3D v2) {
        return v1.distanceInf(v2);
    }

    public static <T extends CalculusFieldElement<T>> T distanceInf(Vector3D v1, FieldVector3D<T> v2) {
        return v2.distanceInf(v1);
    }

    public static <T extends CalculusFieldElement<T>> T distanceSq(FieldVector3D<T> v1, FieldVector3D<T> v2) {
        return v1.distanceSq(v2);
    }

    public static <T extends CalculusFieldElement<T>> T distanceSq(FieldVector3D<T> v1, Vector3D v2) {
        return v1.distanceSq(v2);
    }

    public static <T extends CalculusFieldElement<T>> T distanceSq(Vector3D v1, FieldVector3D<T> v2) {
        return v2.distanceSq(v1);
    }

    public String toString() {
        return Vector3DFormat.getVector3DFormat().format(this.toVector3D());
    }

    public String toString(NumberFormat format) {
        return new Vector3DFormat(format).format(this.toVector3D());
    }

    public FieldVector3D<T> blendArithmeticallyWith(FieldVector3D<T> other, T blendingValue) throws MathIllegalArgumentException {
        SmoothStepFactory.checkBetweenZeroAndOneIncluded((double)blendingValue.getReal());
        CalculusFieldElement one = (CalculusFieldElement)this.x.getField().getOne();
        return this.scalarMultiply((CalculusFieldElement)one.subtract(blendingValue)).add(other.scalarMultiply(blendingValue));
    }
}

