/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;

public class Geometry {
    private Geometry() {
    }

    public static <S extends Space, P extends Point<S, P>> P barycenter(List<P> points) {
        if (points.isEmpty()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, new Object[]{0});
        }
        Point current = (Point)points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            current = ((Point)points.get(i)).moveTowards(current, (double)i / (double)(i + 1));
        }
        return (P)current;
    }
}

