/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import java.text.NumberFormat;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.euclidean.twod.Vector2DFormat;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldVector2D<T extends CalculusFieldElement<T>> {
    private final T x;
    private final T y;

    public FieldVector2D(T x, T y) {
        this.x = x;
        this.y = y;
    }

    public FieldVector2D(T[] v) throws MathIllegalArgumentException {
        if (v.length != 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{v.length, 2});
        }
        this.x = v[0];
        this.y = v[1];
    }

    public FieldVector2D(T a, FieldVector2D<T> u) {
        this.x = (CalculusFieldElement)a.multiply(u.x);
        this.y = (CalculusFieldElement)a.multiply(u.y);
    }

    public FieldVector2D(T a, Vector2D u) {
        this.x = (CalculusFieldElement)a.multiply(u.getX());
        this.y = (CalculusFieldElement)a.multiply(u.getY());
    }

    public FieldVector2D(double a, FieldVector2D<T> u) {
        this.x = (CalculusFieldElement)u.x.multiply(a);
        this.y = (CalculusFieldElement)u.y.multiply(a);
    }

    public FieldVector2D(T a1, FieldVector2D<T> u1, T a2, FieldVector2D<T> u2) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY());
    }

    public FieldVector2D(T a1, Vector2D u1, T a2, Vector2D u2) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(u1.getX(), a1, u2.getX(), a2);
        this.y = (CalculusFieldElement)prototype.linearCombination(u1.getY(), a1, u2.getY(), a2);
    }

    public FieldVector2D(double a1, FieldVector2D<T> u1, double a2, FieldVector2D<T> u2) {
        T prototype = u1.getX();
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY());
    }

    public FieldVector2D(T a1, FieldVector2D<T> u1, T a2, FieldVector2D<T> u2, T a3, FieldVector2D<T> u3) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX(), a3, u3.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY(), a3, u3.getY());
    }

    public FieldVector2D(T a1, Vector2D u1, T a2, Vector2D u2, T a3, Vector2D u3) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(u1.getX(), a1, u2.getX(), a2, u3.getX(), a3);
        this.y = (CalculusFieldElement)prototype.linearCombination(u1.getY(), a1, u2.getY(), a2, u3.getY(), a3);
    }

    public FieldVector2D(double a1, FieldVector2D<T> u1, double a2, FieldVector2D<T> u2, double a3, FieldVector2D<T> u3) {
        T prototype = u1.getX();
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX(), a3, u3.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY(), a3, u3.getY());
    }

    public FieldVector2D(T a1, FieldVector2D<T> u1, T a2, FieldVector2D<T> u2, T a3, FieldVector2D<T> u3, T a4, FieldVector2D<T> u4) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX(), a3, u3.getX(), a4, u4.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY(), a3, u3.getY(), a4, u4.getY());
    }

    public FieldVector2D(T a1, Vector2D u1, T a2, Vector2D u2, T a3, Vector2D u3, T a4, Vector2D u4) {
        T prototype = a1;
        this.x = (CalculusFieldElement)prototype.linearCombination(u1.getX(), a1, u2.getX(), a2, u3.getX(), a3, u4.getX(), a4);
        this.y = (CalculusFieldElement)prototype.linearCombination(u1.getY(), a1, u2.getY(), a2, u3.getY(), a3, u4.getY(), a4);
    }

    public FieldVector2D(double a1, FieldVector2D<T> u1, double a2, FieldVector2D<T> u2, double a3, FieldVector2D<T> u3, double a4, FieldVector2D<T> u4) {
        T prototype = u1.getX();
        this.x = (CalculusFieldElement)prototype.linearCombination(a1, u1.getX(), a2, u2.getX(), a3, u3.getX(), a4, u4.getX());
        this.y = (CalculusFieldElement)prototype.linearCombination(a1, u1.getY(), a2, u2.getY(), a3, u3.getY(), a4, u4.getY());
    }

    public FieldVector2D(Field<T> field, Vector2D v) {
        this.x = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(v.getX());
        this.y = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(v.getY());
    }

    public static <T extends CalculusFieldElement<T>> FieldVector2D<T> getZero(Field<T> field) {
        return new FieldVector2D<T>(field, Vector2D.ZERO);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector2D<T> getPlusI(Field<T> field) {
        return new FieldVector2D<T>(field, Vector2D.PLUS_I);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector2D<T> getMinusI(Field<T> field) {
        return new FieldVector2D<T>(field, Vector2D.MINUS_I);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector2D<T> getPlusJ(Field<T> field) {
        return new FieldVector2D<T>(field, Vector2D.PLUS_J);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector2D<T> getMinusJ(Field<T> field) {
        return new FieldVector2D<T>(field, Vector2D.MINUS_J);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector2D<T> getNaN(Field<T> field) {
        return new FieldVector2D<T>(field, Vector2D.NaN);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector2D<T> getPositiveInfinity(Field<T> field) {
        return new FieldVector2D<T>(field, Vector2D.POSITIVE_INFINITY);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector2D<T> getNegativeInfinity(Field<T> field) {
        return new FieldVector2D<T>(field, Vector2D.NEGATIVE_INFINITY);
    }

    public T getX() {
        return this.x;
    }

    public T getY() {
        return this.y;
    }

    public T[] toArray() {
        CalculusFieldElement[] array = (CalculusFieldElement[])MathArrays.buildArray((Field)this.x.getField(), (int)2);
        array[0] = this.x;
        array[1] = this.y;
        return array;
    }

    public Vector2D toVector2D() {
        return new Vector2D(this.x.getReal(), this.y.getReal());
    }

    public T getNorm1() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.x.abs()).add((FieldElement)((CalculusFieldElement)this.y.abs())));
    }

    public T getNorm() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.x.square()).add((FieldElement)((CalculusFieldElement)this.y.square()))).sqrt());
    }

    public T getNormSq() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.x.square()).add((FieldElement)((CalculusFieldElement)this.y.square())));
    }

    public T getNormInf() {
        return (T)FastMath.max((CalculusFieldElement)FastMath.abs(this.x), (CalculusFieldElement)FastMath.abs(this.y));
    }

    public FieldVector2D<T> add(FieldVector2D<T> v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.add(v.x), (CalculusFieldElement)this.y.add(v.y));
    }

    public FieldVector2D<T> add(Vector2D v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.add(v.getX()), (CalculusFieldElement)this.y.add(v.getY()));
    }

    public FieldVector2D<T> add(T factor, FieldVector2D<T> v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.getField().getOne(), (FieldVector2D<CalculusFieldElement>)this, (CalculusFieldElement)factor, (FieldVector2D<CalculusFieldElement>)v);
    }

    public FieldVector2D<T> add(T factor, Vector2D v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.add((FieldElement)((CalculusFieldElement)factor.multiply(v.getX()))), (CalculusFieldElement)this.y.add((FieldElement)((CalculusFieldElement)factor.multiply(v.getY()))));
    }

    public FieldVector2D<T> add(double factor, FieldVector2D<T> v) {
        return new FieldVector2D<T>(1.0, this, factor, v);
    }

    public FieldVector2D<T> add(double factor, Vector2D v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.add(factor * v.getX()), (CalculusFieldElement)this.y.add(factor * v.getY()));
    }

    public FieldVector2D<T> subtract(FieldVector2D<T> v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.subtract(v.x), (CalculusFieldElement)this.y.subtract(v.y));
    }

    public FieldVector2D<T> subtract(Vector2D v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.subtract(v.getX()), (CalculusFieldElement)this.y.subtract(v.getY()));
    }

    public FieldVector2D<T> subtract(T factor, FieldVector2D<T> v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.getField().getOne(), this, (CalculusFieldElement)factor.negate(), v);
    }

    public FieldVector2D<T> subtract(T factor, Vector2D v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.subtract((FieldElement)((CalculusFieldElement)factor.multiply(v.getX()))), (CalculusFieldElement)this.y.subtract((FieldElement)((CalculusFieldElement)factor.multiply(v.getY()))));
    }

    public FieldVector2D<T> subtract(double factor, FieldVector2D<T> v) {
        return new FieldVector2D<T>(1.0, this, -factor, v);
    }

    public FieldVector2D<T> subtract(double factor, Vector2D v) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.subtract(factor * v.getX()), (CalculusFieldElement)this.y.subtract(factor * v.getY()));
    }

    public FieldVector2D<T> normalize() throws MathRuntimeException {
        T s = this.getNorm();
        if (s.getReal() == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedGeometryFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply((CalculusFieldElement)s.reciprocal());
    }

    public static <T extends CalculusFieldElement<T>> T angle(FieldVector2D<T> v1, FieldVector2D<T> v2) throws MathRuntimeException {
        CalculusFieldElement normProduct = (CalculusFieldElement)v1.getNorm().multiply(v2.getNorm());
        if (normProduct.getReal() == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        T dot = v1.dotProduct(v2);
        double threshold = normProduct.getReal() * 0.9999;
        if (FastMath.abs((double)dot.getReal()) > threshold) {
            CalculusFieldElement n = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)dot.linearCombination(v1.x, v2.y, (FieldElement)((CalculusFieldElement)v1.y.negate()), v2.x)));
            if (dot.getReal() >= 0.0) {
                return (T)FastMath.asin((CalculusFieldElement)((CalculusFieldElement)n.divide((FieldElement)normProduct)));
            }
            return (T)((CalculusFieldElement)((CalculusFieldElement)FastMath.asin((CalculusFieldElement)((CalculusFieldElement)n.divide((FieldElement)normProduct))).negate()).add((FieldElement)((CalculusFieldElement)dot.getPi())));
        }
        return (T)FastMath.acos((CalculusFieldElement)((CalculusFieldElement)dot.divide((FieldElement)normProduct)));
    }

    public static <T extends CalculusFieldElement<T>> T angle(FieldVector2D<T> v1, Vector2D v2) throws MathRuntimeException {
        CalculusFieldElement normProduct = (CalculusFieldElement)v1.getNorm().multiply(v2.getNorm());
        if (normProduct.getReal() == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        T dot = v1.dotProduct(v2);
        double threshold = normProduct.getReal() * 0.9999;
        if (FastMath.abs((double)dot.getReal()) > threshold) {
            CalculusFieldElement n = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)dot.linearCombination(v2.getY(), v1.x, v2.getX(), (FieldElement)((CalculusFieldElement)v1.y.negate()))));
            if (dot.getReal() >= 0.0) {
                return (T)FastMath.asin((CalculusFieldElement)((CalculusFieldElement)n.divide((FieldElement)normProduct)));
            }
            return (T)((CalculusFieldElement)((CalculusFieldElement)FastMath.asin((CalculusFieldElement)((CalculusFieldElement)n.divide((FieldElement)normProduct))).negate()).add((FieldElement)((CalculusFieldElement)dot.getPi())));
        }
        return (T)FastMath.acos((CalculusFieldElement)((CalculusFieldElement)dot.divide((FieldElement)normProduct)));
    }

    public static <T extends CalculusFieldElement<T>> T angle(Vector2D v1, FieldVector2D<T> v2) throws MathRuntimeException {
        return FieldVector2D.angle(v2, v1);
    }

    public FieldVector2D<T> negate() {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.negate(), (CalculusFieldElement)this.y.negate());
    }

    public FieldVector2D<T> scalarMultiply(T a) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.multiply(a), (CalculusFieldElement)this.y.multiply(a));
    }

    public FieldVector2D<T> scalarMultiply(double a) {
        return new FieldVector2D<CalculusFieldElement>((CalculusFieldElement)this.x.multiply(a), (CalculusFieldElement)this.y.multiply(a));
    }

    public boolean isNaN() {
        return Double.isNaN(this.x.getReal()) || Double.isNaN(this.y.getReal());
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.x.getReal()) || Double.isInfinite(this.y.getReal()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FieldVector2D) {
            FieldVector2D rhs = (FieldVector2D)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return this.x.equals(rhs.x) && this.y.equals(rhs.y);
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 122 * (76 * this.x.hashCode() + this.y.hashCode());
    }

    public T distance1(FieldVector2D<T> v) {
        CalculusFieldElement dx = (CalculusFieldElement)((CalculusFieldElement)v.x.subtract(this.x)).abs();
        CalculusFieldElement dy = (CalculusFieldElement)((CalculusFieldElement)v.y.subtract(this.y)).abs();
        return (T)((CalculusFieldElement)dx.add((FieldElement)dy));
    }

    public T distance1(Vector2D v) {
        CalculusFieldElement dx = (CalculusFieldElement)((CalculusFieldElement)this.x.subtract(v.getX())).abs();
        CalculusFieldElement dy = (CalculusFieldElement)((CalculusFieldElement)this.y.subtract(v.getY())).abs();
        return (T)((CalculusFieldElement)dx.add((FieldElement)dy));
    }

    public T distance(FieldVector2D<T> v) {
        CalculusFieldElement dx = (CalculusFieldElement)v.x.subtract(this.x);
        CalculusFieldElement dy = (CalculusFieldElement)v.y.subtract(this.y);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square()))).sqrt());
    }

    public T distance(Vector2D v) {
        CalculusFieldElement dx = (CalculusFieldElement)this.x.subtract(v.getX());
        CalculusFieldElement dy = (CalculusFieldElement)this.y.subtract(v.getY());
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square()))).sqrt());
    }

    public T distanceInf(FieldVector2D<T> v) {
        CalculusFieldElement dx = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)this.x.subtract(v.x)));
        CalculusFieldElement dy = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)this.y.subtract(v.y)));
        return (T)FastMath.max((CalculusFieldElement)dx, (CalculusFieldElement)dy);
    }

    public T distanceInf(Vector2D v) {
        CalculusFieldElement dx = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)this.x.subtract(v.getX())));
        CalculusFieldElement dy = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)this.y.subtract(v.getY())));
        return (T)FastMath.max((CalculusFieldElement)dx, (CalculusFieldElement)dy);
    }

    public T distanceSq(FieldVector2D<T> v) {
        CalculusFieldElement dx = (CalculusFieldElement)v.x.subtract(this.x);
        CalculusFieldElement dy = (CalculusFieldElement)v.y.subtract(this.y);
        return (T)((CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square())));
    }

    public T distanceSq(Vector2D v) {
        CalculusFieldElement dx = (CalculusFieldElement)this.x.subtract(v.getX());
        CalculusFieldElement dy = (CalculusFieldElement)this.y.subtract(v.getY());
        return (T)((CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square())));
    }

    public T dotProduct(FieldVector2D<T> v) {
        return (T)((CalculusFieldElement)this.x.linearCombination(this.x, v.getX(), this.y, v.getY()));
    }

    public T dotProduct(Vector2D v) {
        return (T)((CalculusFieldElement)this.x.linearCombination(v.getX(), this.x, v.getY(), this.y));
    }

    public T crossProduct(FieldVector2D<T> p1, FieldVector2D<T> p2) {
        CalculusFieldElement x1 = (CalculusFieldElement)p2.getX().subtract(p1.getX());
        CalculusFieldElement y1 = (CalculusFieldElement)this.getY().subtract(p1.getY());
        CalculusFieldElement mx2 = (CalculusFieldElement)p1.getX().subtract(this.getX());
        CalculusFieldElement y2 = (CalculusFieldElement)p2.getY().subtract(p1.getY());
        return (T)((CalculusFieldElement)x1.linearCombination((FieldElement)x1, (FieldElement)y1, (FieldElement)mx2, (FieldElement)y2));
    }

    public T crossProduct(Vector2D p1, Vector2D p2) {
        double x1 = p2.getX() - p1.getX();
        CalculusFieldElement y1 = (CalculusFieldElement)this.getY().subtract(p1.getY());
        CalculusFieldElement x2 = (CalculusFieldElement)this.getX().subtract(p1.getX());
        double y2 = p2.getY() - p1.getY();
        return (T)((CalculusFieldElement)y1.linearCombination(x1, (FieldElement)y1, -y2, (FieldElement)x2));
    }

    public static <T extends CalculusFieldElement<T>> T distance1(FieldVector2D<T> p1, FieldVector2D<T> p2) {
        return p1.distance1(p2);
    }

    public static <T extends CalculusFieldElement<T>> T distance1(FieldVector2D<T> p1, Vector2D p2) {
        return p1.distance1(p2);
    }

    public static <T extends CalculusFieldElement<T>> T distance1(Vector2D p1, FieldVector2D<T> p2) {
        return p2.distance1(p1);
    }

    public static <T extends CalculusFieldElement<T>> T distance(FieldVector2D<T> p1, FieldVector2D<T> p2) {
        return p1.distance(p2);
    }

    public static <T extends CalculusFieldElement<T>> T distance(FieldVector2D<T> p1, Vector2D p2) {
        return p1.distance(p2);
    }

    public static <T extends CalculusFieldElement<T>> T distance(Vector2D p1, FieldVector2D<T> p2) {
        return p2.distance(p1);
    }

    public static <T extends CalculusFieldElement<T>> T distanceInf(FieldVector2D<T> p1, FieldVector2D<T> p2) {
        return p1.distanceInf(p2);
    }

    public static <T extends CalculusFieldElement<T>> T distanceInf(FieldVector2D<T> p1, Vector2D p2) {
        return p1.distanceInf(p2);
    }

    public static <T extends CalculusFieldElement<T>> T distanceInf(Vector2D p1, FieldVector2D<T> p2) {
        return p2.distanceInf(p1);
    }

    public static <T extends CalculusFieldElement<T>> T distanceSq(FieldVector2D<T> p1, FieldVector2D<T> p2) {
        return p1.distanceSq(p2);
    }

    public static <T extends CalculusFieldElement<T>> T distanceSq(FieldVector2D<T> p1, Vector2D p2) {
        return p1.distanceSq(p2);
    }

    public static <T extends CalculusFieldElement<T>> T distanceSq(Vector2D p1, FieldVector2D<T> p2) {
        return p2.distanceSq(p1);
    }

    public static <T extends CalculusFieldElement<T>> T orientation(FieldVector2D<T> p, FieldVector2D<T> q, FieldVector2D<T> r) {
        T prototype = p.getX();
        CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray((Field)prototype.getField(), (int)6);
        a[0] = p.getX();
        a[1] = (CalculusFieldElement)p.getX().negate();
        a[2] = q.getX();
        a[3] = (CalculusFieldElement)q.getX().negate();
        a[4] = r.getX();
        a[5] = (CalculusFieldElement)r.getX().negate();
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray((Field)prototype.getField(), (int)6);
        b[0] = q.getY();
        b[1] = r.getY();
        b[2] = r.getY();
        b[3] = p.getY();
        b[4] = p.getY();
        b[5] = q.getY();
        return (T)((CalculusFieldElement)prototype.linearCombination((FieldElement[])a, (FieldElement[])b));
    }

    public String toString() {
        return Vector2DFormat.getVector2DFormat().format(this.toVector2D());
    }

    public String toString(NumberFormat format) {
        return new Vector2DFormat(format).format(this.toVector2D());
    }
}

