/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples.complex;

import org.hipparchus.complex.Complex;
import org.hipparchus.samples.complex.DomainColoring;
import org.hipparchus.util.FastMath;

public class SawToothPhaseModuleValue
extends DomainColoring {
    private final double minBrightness;
    private final double maxBrightness;
    private final int nbLines;

    protected SawToothPhaseModuleValue(double saturation, double minBrightness, double maxBrightness, int nbLines) {
        super(saturation);
        this.minBrightness = minBrightness;
        this.maxBrightness = maxBrightness;
        this.nbLines = nbLines;
    }

    private double fractionalBrightness(double x, double s) {
        double f = x * (double)this.nbLines / s;
        return this.minBrightness + (this.maxBrightness - this.minBrightness) * (f - FastMath.floor((double)f));
    }

    @Override
    public double value(Complex z) {
        double module = z.norm();
        double bM = this.fractionalBrightness(FastMath.log((double)module), Math.PI * 2);
        double bP = this.fractionalBrightness(this.hue(z), 1.0);
        return bM * bP;
    }
}

