/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;

public class FieldODEState<T extends CalculusFieldElement<T>> {
    private final T time;
    private final T[] primaryState;
    private final T[][] secondaryState;
    private final int completeDimension;

    public FieldODEState(T time, T[] primaryState) {
        this((CalculusFieldElement)time, (CalculusFieldElement[])primaryState, null);
    }

    public FieldODEState(T time, T[] primaryState, T[][] secondaryState) {
        this.time = time;
        this.primaryState = (CalculusFieldElement[])primaryState.clone();
        this.secondaryState = this.copy((CalculusFieldElement[][])secondaryState);
        int dimension = primaryState.length;
        if (secondaryState != null) {
            for (T[] secondary : secondaryState) {
                dimension += secondary.length;
            }
        }
        this.completeDimension = dimension;
    }

    protected T[][] copy(T[][] original) {
        if (original == null) {
            return null;
        }
        CalculusFieldElement[][] copied = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.time.getField(), (int)original.length, (int)-1);
        for (int i = 0; i < original.length; ++i) {
            copied[i] = (CalculusFieldElement[])original[i].clone();
        }
        return copied;
    }

    public T getTime() {
        return this.time;
    }

    public int getPrimaryStateDimension() {
        return this.primaryState.length;
    }

    public T[] getPrimaryState() {
        return (CalculusFieldElement[])this.primaryState.clone();
    }

    public int getNumberOfSecondaryStates() {
        return this.secondaryState == null ? 0 : this.secondaryState.length;
    }

    public int getSecondaryStateDimension(int index) {
        return index == 0 ? this.primaryState.length : this.secondaryState[index - 1].length;
    }

    public T[] getSecondaryState(int index) {
        return index == 0 ? (CalculusFieldElement[])this.primaryState.clone() : (CalculusFieldElement[])this.secondaryState[index - 1].clone();
    }

    public int getCompleteStateDimension() {
        return this.completeDimension;
    }

    public T[] getCompleteState() {
        CalculusFieldElement[] completeState = (CalculusFieldElement[])MathArrays.buildArray((Field)this.time.getField(), (int)this.getCompleteStateDimension());
        System.arraycopy(this.primaryState, 0, completeState, 0, this.primaryState.length);
        int offset = this.primaryState.length;
        if (this.secondaryState != null) {
            for (T[] ts : this.secondaryState) {
                System.arraycopy(ts, 0, completeState, offset, ts.length);
                offset += ts.length;
            }
        }
        return completeState;
    }
}

