/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.EventOccurrence;
import org.hipparchus.ode.events.EventState;
import org.hipparchus.ode.events.ODEStepEndHandler;
import org.hipparchus.ode.sampling.ODEStateInterpolator;

public class StepEndEventState
implements EventState {
    private final ODEStepEndHandler handler;
    private double stepEnd;
    private boolean forward;

    public StepEndEventState(ODEStepEndHandler handler) {
        this.handler = handler;
        this.stepEnd = Double.NaN;
    }

    public ODEStepEndHandler getHandler() {
        return this.handler;
    }

    @Override
    public void init(ODEStateAndDerivative s0, double t) {
        this.forward = t >= s0.getTime();
    }

    public void setStepEnd(double stepEnd) {
        this.stepEnd = stepEnd;
    }

    @Override
    public boolean evaluateStep(ODEStateInterpolator interpolator) {
        return this.stepEnd == interpolator.getCurrentState().getTime();
    }

    @Override
    public double getEventTime() {
        return this.stepEnd;
    }

    @Override
    public EventOccurrence doEvent(ODEStateAndDerivative state) {
        Action action = this.handler.stepEndOccurred(state, this.forward);
        ODEState newState = action == Action.RESET_STATE ? this.handler.resetState(state) : state;
        EventOccurrence occurrence = new EventOccurrence(action, newState, this.stepEnd);
        this.setStepEnd(Double.NaN);
        return occurrence;
    }
}

