/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.FixedStepRungeKuttaIntegrator;
import org.hipparchus.ode.nonstiff.interpolators.ClassicalRungeKuttaStateInterpolator;

public class ClassicalRungeKuttaIntegrator
extends FixedStepRungeKuttaIntegrator {
    public static final String METHOD_NAME = "classical Runge-Kutta";

    public ClassicalRungeKuttaIntegrator(double step) {
        super(METHOD_NAME, step);
    }

    @Override
    public double[] getC() {
        return new double[]{0.5, 0.5, 1.0};
    }

    @Override
    public double[][] getA() {
        return new double[][]{{0.5}, {0.0, 0.5}, {0.0, 0.0, 1.0}};
    }

    @Override
    public double[] getB() {
        return new double[]{0.16666666666666666, 0.3333333333333333, 0.3333333333333333, 0.16666666666666666};
    }

    @Override
    protected ClassicalRungeKuttaStateInterpolator createInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, EquationsMapper mapper) {
        return new ClassicalRungeKuttaStateInterpolator(forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

