/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.filtering.kalman;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.filtering.kalman.KalmanFilter;
import org.hipparchus.filtering.kalman.KalmanObserver;
import org.hipparchus.filtering.kalman.Measurement;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;

public abstract class AbstractKalmanFilter<T extends Measurement>
implements KalmanFilter<T> {
    private final MatrixDecomposer decomposer;
    private ProcessEstimate predicted;
    private ProcessEstimate corrected;
    private RealMatrix priorCovariance;
    private RealMatrix stateTransitionMatrix;
    private KalmanObserver observer;

    protected AbstractKalmanFilter(MatrixDecomposer decomposer, ProcessEstimate initialState) {
        this.decomposer = decomposer;
        this.corrected = initialState;
        this.priorCovariance = null;
        this.stateTransitionMatrix = null;
        this.observer = null;
    }

    protected void predict(double time, RealVector predictedState, RealMatrix stm, RealMatrix noise) {
        RealMatrix predictedCovariance = stm.multiply(this.corrected.getCovariance().multiplyTransposed(stm)).add(noise);
        this.predicted = new ProcessEstimate(time, predictedState, predictedCovariance);
        this.stateTransitionMatrix = stm;
        this.priorCovariance = this.corrected.getCovariance();
        this.corrected = null;
    }

    protected RealMatrix computeInnovationCovarianceMatrix(RealMatrix r, RealMatrix h) {
        if (h == null) {
            return null;
        }
        RealMatrix phT = this.predicted.getCovariance().multiplyTransposed(h);
        return h.multiply(phT).add(r);
    }

    protected void correct(T measurement, RealMatrix stm, RealVector innovation, RealMatrix h, RealMatrix s) throws MathIllegalArgumentException {
        if (innovation == null) {
            this.corrected = this.predicted;
            return;
        }
        RealMatrix k = this.decomposer.decompose(s).solve(h.multiply(this.predicted.getCovariance())).transpose();
        RealVector correctedState = this.predicted.getState().add(k.operate(innovation));
        RealMatrix idMkh = k.multiply(h);
        for (int i = 0; i < idMkh.getRowDimension(); ++i) {
            for (int j = 0; j < idMkh.getColumnDimension(); ++j) {
                idMkh.multiplyEntry(i, j, -1.0);
            }
            idMkh.addToEntry(i, i, 1.0);
        }
        RealMatrix r = measurement.getCovariance();
        RealMatrix correctedCovariance = idMkh.multiply(this.predicted.getCovariance()).multiplyTransposed(idMkh).add(k.multiply(r).multiplyTransposed(k));
        this.corrected = new ProcessEstimate(measurement.getTime(), correctedState, correctedCovariance, stm, h, s, k);
    }

    protected KalmanObserver getObserver() {
        return this.observer;
    }

    @Override
    public void setObserver(KalmanObserver kalmanObserver) {
        this.observer = kalmanObserver;
        this.observer.init(this);
    }

    @Override
    public ProcessEstimate getPredicted() {
        return this.predicted;
    }

    @Override
    public ProcessEstimate getCorrected() {
        return this.corrected;
    }

    @Override
    public RealMatrix getStateCrossCovariance() {
        return this.priorCovariance.multiplyTransposed(this.stateTransitionMatrix);
    }
}

