/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.analysis.differentiation.Derivative1;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.UnivariateDerivative;
import org.hipparchus.analysis.differentiation.UnivariateDerivative1Field;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class UnivariateDerivative1
extends UnivariateDerivative<UnivariateDerivative1>
implements Derivative1<UnivariateDerivative1> {
    public static final UnivariateDerivative1 PI = new UnivariateDerivative1(Math.PI, 0.0);
    private static final long serialVersionUID = 20200519L;
    private final double f0;
    private final double f1;

    public UnivariateDerivative1(double f0, double f1) {
        this.f0 = f0;
        this.f1 = f1;
    }

    public UnivariateDerivative1(DerivativeStructure ds) throws MathIllegalArgumentException {
        MathUtils.checkDimension(ds.getFreeParameters(), 1);
        MathUtils.checkDimension(ds.getOrder(), 1);
        this.f0 = ds.getValue();
        this.f1 = ds.getPartialDerivative(1);
    }

    @Override
    public UnivariateDerivative1 newInstance(double value) {
        return new UnivariateDerivative1(value, 0.0);
    }

    @Override
    public UnivariateDerivative1 withValue(double value) {
        return new UnivariateDerivative1(value, this.f1);
    }

    @Override
    public UnivariateDerivative1 getAddendum() {
        return new UnivariateDerivative1(0.0, this.f1);
    }

    @Override
    public double getValue() {
        return this.f0;
    }

    @Override
    public double getDerivative(int n) {
        switch (n) {
            case 0: {
                return this.f0;
            }
            case 1: {
                return this.f1;
            }
        }
        throw new MathIllegalArgumentException(LocalizedCoreFormats.DERIVATION_ORDER_NOT_ALLOWED, n);
    }

    public double getFirstDerivative() {
        return this.f1;
    }

    @Override
    public DerivativeStructure toDerivativeStructure() {
        return this.getField().getConversionFactory().build(this.f0, this.f1);
    }

    @Override
    public UnivariateDerivative1 add(UnivariateDerivative1 a) {
        return new UnivariateDerivative1(this.f0 + a.f0, this.f1 + a.f1);
    }

    @Override
    public UnivariateDerivative1 subtract(UnivariateDerivative1 a) {
        return new UnivariateDerivative1(this.f0 - a.f0, this.f1 - a.f1);
    }

    @Override
    public UnivariateDerivative1 multiply(int n) {
        return new UnivariateDerivative1(this.f0 * (double)n, this.f1 * (double)n);
    }

    @Override
    public UnivariateDerivative1 multiply(double a) {
        return new UnivariateDerivative1(this.f0 * a, this.f1 * a);
    }

    @Override
    public UnivariateDerivative1 multiply(UnivariateDerivative1 a) {
        return new UnivariateDerivative1(this.f0 * a.f0, MathArrays.linearCombination(this.f1, a.f0, this.f0, a.f1));
    }

    @Override
    public UnivariateDerivative1 divide(double a) {
        double inv1 = 1.0 / a;
        return new UnivariateDerivative1(this.f0 * inv1, this.f1 * inv1);
    }

    @Override
    public UnivariateDerivative1 divide(UnivariateDerivative1 a) {
        double inv1 = 1.0 / a.f0;
        double inv2 = inv1 * inv1;
        return new UnivariateDerivative1(this.f0 * inv1, MathArrays.linearCombination(this.f1, a.f0, -this.f0, a.f1) * inv2);
    }

    @Override
    public UnivariateDerivative1 remainder(UnivariateDerivative1 a) {
        double rem = FastMath.IEEEremainder(this.f0, a.f0);
        double k = FastMath.rint((this.f0 - rem) / a.f0);
        return new UnivariateDerivative1(rem, this.f1 - k * a.f1);
    }

    @Override
    public UnivariateDerivative1 negate() {
        return new UnivariateDerivative1(-this.f0, -this.f1);
    }

    @Override
    public UnivariateDerivative1 abs() {
        if (Double.doubleToLongBits(this.f0) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public UnivariateDerivative1 copySign(UnivariateDerivative1 sign) {
        long m = Double.doubleToLongBits(this.f0);
        long s = Double.doubleToLongBits(sign.f0);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public UnivariateDerivative1 copySign(double sign) {
        long m = Double.doubleToLongBits(this.f0);
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public UnivariateDerivative1 scalb(int n) {
        return new UnivariateDerivative1(FastMath.scalb(this.f0, n), FastMath.scalb(this.f1, n));
    }

    @Override
    public UnivariateDerivative1 hypot(UnivariateDerivative1 y) {
        int expY;
        if (Double.isInfinite(this.f0) || Double.isInfinite(y.f0)) {
            return new UnivariateDerivative1(Double.POSITIVE_INFINITY, 0.0);
        }
        if (Double.isNaN(this.f0) || Double.isNaN(y.f0)) {
            return new UnivariateDerivative1(Double.NaN, 0.0);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        UnivariateDerivative1 scaledX = this.scalb(-middleExp);
        UnivariateDerivative1 scaledY = y.scalb(-middleExp);
        UnivariateDerivative1 scaledH = (UnivariateDerivative1)scaledX.multiply(scaledX).add(scaledY.multiply(scaledY)).sqrt();
        return scaledH.scalb(middleExp);
    }

    @Override
    public UnivariateDerivative1 compose(double ... f) {
        MathUtils.checkDimension(f.length, this.getOrder() + 1);
        return this.compose(f[0], f[1]);
    }

    @Override
    public UnivariateDerivative1 compose(double ff0, double ff1) {
        return new UnivariateDerivative1(ff0, this.f1 * ff1);
    }

    public UnivariateDerivative1Field getField() {
        return UnivariateDerivative1Field.getInstance();
    }

    public static UnivariateDerivative1 pow(double a, UnivariateDerivative1 x) {
        if (a == 0.0) {
            return x.getField().getZero();
        }
        double aX = FastMath.pow(a, x.f0);
        return new UnivariateDerivative1(aX, FastMath.log(a) * aX * x.f1);
    }

    @Override
    public UnivariateDerivative1 pow(double p) {
        if (p == 0.0) {
            return this.getField().getOne();
        }
        double f0Pm1 = FastMath.pow(this.f0, p - 1.0);
        return this.compose(f0Pm1 * this.f0, p * f0Pm1);
    }

    @Override
    public UnivariateDerivative1 pow(int n) {
        if (n == 0) {
            return this.getField().getOne();
        }
        double f0Nm1 = FastMath.pow(this.f0, n - 1);
        return this.compose(f0Nm1 * this.f0, (double)n * f0Nm1);
    }

    @Override
    public UnivariateDerivative1 atan2(UnivariateDerivative1 x) {
        double inv = 1.0 / (this.f0 * this.f0 + x.f0 * x.f0);
        return new UnivariateDerivative1(FastMath.atan2(this.f0, x.f0), MathArrays.linearCombination(x.f0, this.f1, -x.f1, this.f0) * inv);
    }

    @Override
    public UnivariateDerivative1 toDegrees() {
        return new UnivariateDerivative1(FastMath.toDegrees(this.f0), FastMath.toDegrees(this.f1));
    }

    @Override
    public UnivariateDerivative1 toRadians() {
        return new UnivariateDerivative1(FastMath.toRadians(this.f0), FastMath.toRadians(this.f1));
    }

    public double taylor(double delta) {
        return this.f0 + delta * this.f1;
    }

    public UnivariateDerivative1 linearCombination(UnivariateDerivative1[] a, UnivariateDerivative1[] b) {
        int n = a.length;
        double[] a0 = new double[n];
        double[] b0 = new double[n];
        double[] a1 = new double[2 * n];
        double[] b1 = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            UnivariateDerivative1 ai = a[i];
            UnivariateDerivative1 bi = b[i];
            a0[i] = ai.f0;
            b0[i] = bi.f0;
            a1[2 * i] = ai.f0;
            a1[2 * i + 1] = ai.f1;
            b1[2 * i] = bi.f1;
            b1[2 * i + 1] = bi.f0;
        }
        return new UnivariateDerivative1(MathArrays.linearCombination(a0, b0), MathArrays.linearCombination(a1, b1));
    }

    public UnivariateDerivative1 linearCombination(double[] a, UnivariateDerivative1[] b) {
        int n = b.length;
        double[] b0 = new double[n];
        double[] b1 = new double[n];
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].f0;
            b1[i] = b[i].f1;
        }
        return new UnivariateDerivative1(MathArrays.linearCombination(a, b0), MathArrays.linearCombination(a, b1));
    }

    @Override
    public UnivariateDerivative1 linearCombination(UnivariateDerivative1 a1, UnivariateDerivative1 b1, UnivariateDerivative1 a2, UnivariateDerivative1 b2) {
        return new UnivariateDerivative1(MathArrays.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0), MathArrays.linearCombination(a1.f0, b1.f1, a1.f1, b1.f0, a2.f0, b2.f1, a2.f1, b2.f0));
    }

    @Override
    public UnivariateDerivative1 linearCombination(double a1, UnivariateDerivative1 b1, double a2, UnivariateDerivative1 b2) {
        return new UnivariateDerivative1(MathArrays.linearCombination(a1, b1.f0, a2, b2.f0), MathArrays.linearCombination(a1, b1.f1, a2, b2.f1));
    }

    @Override
    public UnivariateDerivative1 linearCombination(UnivariateDerivative1 a1, UnivariateDerivative1 b1, UnivariateDerivative1 a2, UnivariateDerivative1 b2, UnivariateDerivative1 a3, UnivariateDerivative1 b3) {
        return new UnivariateDerivative1(MathArrays.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0, a3.f0, b3.f0), MathArrays.linearCombination(new double[]{a1.f0, a1.f1, a2.f0, a2.f1, a3.f0, a3.f1}, new double[]{b1.f1, b1.f0, b2.f1, b2.f0, b3.f1, b3.f0}));
    }

    @Override
    public UnivariateDerivative1 linearCombination(double a1, UnivariateDerivative1 b1, double a2, UnivariateDerivative1 b2, double a3, UnivariateDerivative1 b3) {
        return new UnivariateDerivative1(MathArrays.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0), MathArrays.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1));
    }

    @Override
    public UnivariateDerivative1 linearCombination(UnivariateDerivative1 a1, UnivariateDerivative1 b1, UnivariateDerivative1 a2, UnivariateDerivative1 b2, UnivariateDerivative1 a3, UnivariateDerivative1 b3, UnivariateDerivative1 a4, UnivariateDerivative1 b4) {
        return new UnivariateDerivative1(MathArrays.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0, a3.f0, b3.f0, a4.f0, b4.f0), MathArrays.linearCombination(new double[]{a1.f0, a1.f1, a2.f0, a2.f1, a3.f0, a3.f1, a4.f0, a4.f1}, new double[]{b1.f1, b1.f0, b2.f1, b2.f0, b3.f1, b3.f0, b4.f1, b4.f0}));
    }

    @Override
    public UnivariateDerivative1 linearCombination(double a1, UnivariateDerivative1 b1, double a2, UnivariateDerivative1 b2, double a3, UnivariateDerivative1 b3, double a4, UnivariateDerivative1 b4) {
        return new UnivariateDerivative1(MathArrays.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0, a4, b4.f0), MathArrays.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1, a4, b4.f1));
    }

    @Override
    public UnivariateDerivative1 getPi() {
        return PI;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UnivariateDerivative1) {
            UnivariateDerivative1 rhs = (UnivariateDerivative1)other;
            return this.f0 == rhs.f0 && this.f1 == rhs.f1;
        }
        return false;
    }

    public int hashCode() {
        return 453 - 19 * Double.hashCode(this.f0) + 37 * Double.hashCode(this.f1);
    }

    @Override
    public int compareTo(UnivariateDerivative1 o) {
        int cF0 = Double.compare(this.f0, o.getReal());
        if (cF0 == 0) {
            return Double.compare(this.f1, o.getFirstDerivative());
        }
        return cF0;
    }
}

