/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.analysis.integration.gauss.AbstractRuleFactory;
import org.hipparchus.util.Pair;

public class LaguerreRuleFactory
extends AbstractRuleFactory {
    @Override
    protected Pair<double[], double[]> computeRule(int numberOfPoints) {
        double[] points = this.findRoots(numberOfPoints, new Laguerre(numberOfPoints)::ratio);
        double[] weights = new double[numberOfPoints];
        int n1 = numberOfPoints + 1;
        long n1Squared = (long)n1 * (long)n1;
        Laguerre laguerreN1 = new Laguerre(n1);
        for (int i = 0; i < numberOfPoints; ++i) {
            double val = laguerreN1.value(points[i]);
            weights[i] = points[i] / ((double)n1Squared * val * val);
        }
        return new Pair<double[], double[]>(points, weights);
    }

    private static class Laguerre {
        private int degree;

        Laguerre(int degree) {
            this.degree = degree;
        }

        public double value(double x) {
            return this.lNlNm1(x)[0];
        }

        public double ratio(double x) {
            double[] l = this.lNlNm1(x);
            return x * l[0] / ((double)this.degree * (l[0] - l[1]));
        }

        private double[] lNlNm1(double x) {
            double[] l = new double[]{1.0 - x, 1.0};
            for (int n = 1; n < this.degree; ++n) {
                double lp = (l[0] * ((double)(2 * n + 1) - x) - l[1] * (double)n) / (double)(n + 1);
                l[1] = l[0];
                l[0] = lp;
            }
            return l;
        }
    }
}

