/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.CalculusFieldBivariateFunction;
import org.hipparchus.analysis.interpolation.FieldGridAxis;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;

public class FieldBilinearInterpolatingFunction<T extends CalculusFieldElement<T>>
implements CalculusFieldBivariateFunction<T> {
    private final FieldGridAxis<T> xGrid;
    private final FieldGridAxis<T> yGrid;
    private final int ySize;
    private final T[] fVal;

    public FieldBilinearInterpolatingFunction(T[] xVal, T[] yVal, T[][] fVal) throws MathIllegalArgumentException {
        Field field = fVal[0][0].getField();
        this.xGrid = new FieldGridAxis(xVal, 2);
        this.yGrid = new FieldGridAxis(yVal, 2);
        this.ySize = yVal.length;
        this.fVal = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(xVal.length * this.ySize));
        int k = 0;
        for (int i = 0; i < xVal.length; ++i) {
            T[] fi = fVal[i];
            for (int j = 0; j < this.ySize; ++j) {
                this.fVal[k++] = fi[j];
            }
        }
    }

    public T getXInf() {
        return this.xGrid.node(0);
    }

    public T getXSup() {
        return this.xGrid.node(this.xGrid.size() - 1);
    }

    public T getYInf() {
        return this.yGrid.node(0);
    }

    public T getYSup() {
        return this.yGrid.node(this.yGrid.size() - 1);
    }

    @Override
    public T value(T x, T y) {
        int i = this.xGrid.interpolationIndex(x);
        int j = this.yGrid.interpolationIndex(y);
        T x0 = this.xGrid.node(i);
        T x1 = this.xGrid.node(i + 1);
        T y0 = this.yGrid.node(j);
        T y1 = this.yGrid.node(j + 1);
        int k0 = i * this.ySize + j;
        int k1 = k0 + this.ySize;
        T z00 = this.fVal[k0];
        T z01 = this.fVal[k0 + 1];
        T z10 = this.fVal[k1];
        T z11 = this.fVal[k1 + 1];
        CalculusFieldElement dx0 = (CalculusFieldElement)x.subtract(x0);
        CalculusFieldElement mdx1 = (CalculusFieldElement)x.subtract(x1);
        CalculusFieldElement dx10 = (CalculusFieldElement)x1.subtract(x0);
        CalculusFieldElement dy0 = (CalculusFieldElement)y.subtract(y0);
        CalculusFieldElement mdy1 = (CalculusFieldElement)y.subtract(y1);
        CalculusFieldElement dy10 = (CalculusFieldElement)y1.subtract(y0);
        return (T)((CalculusFieldElement)dy0.multiply(z11)).subtract((CalculusFieldElement)mdy1.multiply(z10)).multiply(dx0).subtract(((CalculusFieldElement)dy0.multiply(z01)).subtract((CalculusFieldElement)mdy1.multiply(z00)).multiply(mdx1)).divide(dx10.multiply(dy10));
    }
}

