/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import org.hipparchus.analysis.interpolation.BivariateGridInterpolator;
import org.hipparchus.analysis.interpolation.PiecewiseBicubicSplineInterpolatingFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathArrays;

public class PiecewiseBicubicSplineInterpolator
implements BivariateGridInterpolator {
    @Override
    public PiecewiseBicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws MathIllegalArgumentException, NullArgumentException {
        if (xval == null || yval == null || fval == null || fval[0] == null) {
            throw new NullArgumentException();
        }
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        MathArrays.checkOrder(xval);
        MathArrays.checkOrder(yval);
        return new PiecewiseBicubicSplineInterpolatingFunction(xval, yval, fval);
    }
}

