/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.polynomials;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.polynomials.FieldPolynomialFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldPolynomialSplineFunction<T extends CalculusFieldElement<T>>
implements CalculusFieldUnivariateFunction<T> {
    private final T[] knots;
    private final FieldPolynomialFunction<T>[] polynomials;
    private final int n;

    public FieldPolynomialSplineFunction(T[] knots, FieldPolynomialFunction<T>[] polynomials) throws MathIllegalArgumentException, NullArgumentException {
        if (knots == null || polynomials == null) {
            throw new NullArgumentException();
        }
        if (knots.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_ENOUGH_POINTS_IN_SPLINE_PARTITION, 2, knots.length, false);
        }
        MathUtils.checkDimension(polynomials.length, knots.length - 1);
        MathArrays.checkOrder(knots);
        this.n = knots.length - 1;
        this.knots = (CalculusFieldElement[])knots.clone();
        this.polynomials = (FieldPolynomialFunction[])Array.newInstance(FieldPolynomialFunction.class, this.n);
        System.arraycopy(polynomials, 0, this.polynomials, 0, this.n);
    }

    public Field<T> getField() {
        return this.knots[0].getField();
    }

    @Override
    public T value(double v) {
        return (T)this.value((CalculusFieldElement)((CalculusFieldElement)this.getField().getZero()).add(v));
    }

    @Override
    public T value(T v) {
        MathUtils.checkRangeInclusive(v.getReal(), this.knots[0].getReal(), this.knots[this.n].getReal());
        int i = Arrays.binarySearch(Arrays.stream(this.knots).map(FieldElement::getReal).toArray(), (Object)v.getReal());
        if (i < 0) {
            i = -i - 2;
        }
        if (i >= this.polynomials.length) {
            --i;
        }
        return (T)this.polynomials[i].value((CalculusFieldElement)v.subtract(this.knots[i]));
    }

    public int getN() {
        return this.n;
    }

    public FieldPolynomialFunction<T>[] getPolynomials() {
        return (FieldPolynomialFunction[])this.polynomials.clone();
    }

    public T[] getKnots() {
        return (CalculusFieldElement[])this.knots.clone();
    }

    public boolean isValidPoint(T x) {
        return !(x.getReal() < this.knots[0].getReal()) && !(x.getReal() > this.knots[this.n].getReal());
    }

    public FieldPolynomialSplineFunction<T> polynomialSplineDerivative() {
        FieldPolynomialFunction[] derivativePolynomials = (FieldPolynomialFunction[])Array.newInstance(FieldPolynomialFunction.class, this.n);
        for (int i = 0; i < this.n; ++i) {
            derivativePolynomials[i] = this.polynomials[i].polynomialDerivative();
        }
        return new FieldPolynomialSplineFunction(this.knots, derivativePolynomials);
    }
}

