/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.polynomials;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.FieldUnivariateFunction;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class PolynomialSplineFunction
implements UnivariateDifferentiableFunction,
FieldUnivariateFunction {
    private final double[] knots;
    private final PolynomialFunction[] polynomials;
    private final int n;

    public PolynomialSplineFunction(double[] knots, PolynomialFunction[] polynomials) throws MathIllegalArgumentException, NullArgumentException {
        if (knots == null || polynomials == null) {
            throw new NullArgumentException();
        }
        if (knots.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_ENOUGH_POINTS_IN_SPLINE_PARTITION, 2, knots.length, false);
        }
        MathUtils.checkDimension(polynomials.length, knots.length - 1);
        MathArrays.checkOrder(knots);
        this.n = knots.length - 1;
        this.knots = new double[this.n + 1];
        System.arraycopy(knots, 0, this.knots, 0, this.n + 1);
        this.polynomials = new PolynomialFunction[this.n];
        System.arraycopy(polynomials, 0, this.polynomials, 0, this.n);
    }

    @Override
    public double value(double v) {
        MathUtils.checkRangeInclusive(v, this.knots[0], this.knots[this.n]);
        int i = Arrays.binarySearch(this.knots, v);
        if (i < 0) {
            i = -i - 2;
        }
        if (i >= this.polynomials.length) {
            --i;
        }
        return this.polynomials[i].value(v - this.knots[i]);
    }

    public PolynomialSplineFunction polynomialSplineDerivative() {
        PolynomialFunction[] derivativePolynomials = new PolynomialFunction[this.n];
        for (int i = 0; i < this.n; ++i) {
            derivativePolynomials[i] = this.polynomials[i].polynomialDerivative();
        }
        return new PolynomialSplineFunction(this.knots, derivativePolynomials);
    }

    @Override
    public <T extends Derivative<T>> T value(T t) {
        double t0 = t.getReal();
        MathUtils.checkRangeInclusive(t0, this.knots[0], this.knots[this.n]);
        int i = Arrays.binarySearch(this.knots, t0);
        if (i < 0) {
            i = -i - 2;
        }
        if (i >= this.polynomials.length) {
            --i;
        }
        return (T)this.polynomials[i].value((Derivative)t.subtract(this.knots[i]));
    }

    @Override
    public <T extends CalculusFieldElement<T>> T value(T t) {
        double t0 = t.getReal();
        MathUtils.checkRangeInclusive(t0, this.knots[0], this.knots[this.n]);
        int i = Arrays.binarySearch(this.knots, t0);
        if (i < 0) {
            i = -i - 2;
        }
        if (i >= this.polynomials.length) {
            --i;
        }
        return (T)this.polynomials[i].value((CalculusFieldElement)t.subtract((double)this.knots[i]));
    }

    public int getN() {
        return this.n;
    }

    public PolynomialFunction[] getPolynomials() {
        PolynomialFunction[] p = new PolynomialFunction[this.n];
        System.arraycopy(this.polynomials, 0, p, 0, this.n);
        return p;
    }

    public double[] getKnots() {
        double[] out = new double[this.n + 1];
        System.arraycopy(this.knots, 0, out, 0, this.n + 1);
        return out;
    }

    public boolean isValidPoint(double x) {
        return x >= this.knots[0] && x <= this.knots[this.n];
    }
}

