/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.polynomials;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.polynomials.FieldPolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathArrays;

public class SmoothStepFactory {
    private SmoothStepFactory() {
    }

    public static SmoothStepFunction getClamp() {
        return SmoothStepFactory.getGeneralOrder(0);
    }

    public static SmoothStepFunction getQuadratic() {
        return new QuadraticSmoothStepFunction(new double[]{0.0});
    }

    public static SmoothStepFunction getCubic() {
        return SmoothStepFactory.getGeneralOrder(1);
    }

    public static SmoothStepFunction getQuintic() {
        return SmoothStepFactory.getGeneralOrder(2);
    }

    public static <T extends CalculusFieldElement<T>> FieldSmoothStepFunction<T> getClamp(Field<T> field) {
        return SmoothStepFactory.getFieldGeneralOrder(field, 0);
    }

    public static <T extends CalculusFieldElement<T>> FieldSmoothStepFunction<T> getQuadratic(Field<T> field) {
        CalculusFieldElement[] tempArray = (CalculusFieldElement[])MathArrays.buildArray(field, (int)1);
        return new FieldQuadraticSmoothStepFunction(tempArray);
    }

    public static <T extends CalculusFieldElement<T>> FieldSmoothStepFunction<T> getCubic(Field<T> field) {
        return SmoothStepFactory.getFieldGeneralOrder(field, 1);
    }

    public static <T extends CalculusFieldElement<T>> FieldSmoothStepFunction<T> getQuintic(Field<T> field) {
        return SmoothStepFactory.getFieldGeneralOrder(field, 2);
    }

    public static SmoothStepFunction getGeneralOrder(int N) {
        int twoNPlusOne = 2 * N + 1;
        double[] coefficients = new double[twoNPlusOne + 1];
        int n = N;
        for (int i = twoNPlusOne; i > N; --i) {
            coefficients[i] = SmoothStepFactory.pascalTriangle(-N - 1, n) * SmoothStepFactory.pascalTriangle(2 * N + 1, N - n);
            --n;
        }
        return new SmoothStepFunction(coefficients);
    }

    public static <T extends CalculusFieldElement<T>> FieldSmoothStepFunction<T> getFieldGeneralOrder(Field<T> field, int N) {
        int twoNPlusOne = 2 * N + 1;
        CalculusFieldElement[] coefficients = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(twoNPlusOne + 1));
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        int n = N;
        for (int i = twoNPlusOne; i > N; --i) {
            coefficients[i] = (CalculusFieldElement)one.newInstance(SmoothStepFactory.pascalTriangle(-N - 1, n) * SmoothStepFactory.pascalTriangle(2 * N + 1, N - n));
            --n;
        }
        return new FieldSmoothStepFunction(coefficients);
    }

    private static int pascalTriangle(int k, int n) {
        int result = 1;
        for (int i = 0; i < n; ++i) {
            result *= (k - i) / (i + 1);
        }
        return result;
    }

    public static void checkBetweenZeroAndOneIncluded(double input) throws MathIllegalArgumentException {
        if (input < 0.0 || input > 1.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INPUT_EXPECTED_BETWEEN_ZERO_AND_ONE_INCLUDED, new Object[0]);
        }
    }

    private static class FieldQuadraticSmoothStepFunction<T extends CalculusFieldElement<T>>
    extends FieldSmoothStepFunction<T> {
        private FieldQuadraticSmoothStepFunction(T[] c) throws MathIllegalArgumentException, NullArgumentException {
            super((CalculusFieldElement[])c);
        }

        @Override
        public T value(double leftEdge, double rightEdge, T x) throws MathIllegalArgumentException {
            this.checkInputEdges(leftEdge, rightEdge);
            T xClamped = this.clampInput(leftEdge, rightEdge, x);
            T xNormalized = this.normalizeInput(leftEdge, rightEdge, xClamped);
            return this.value(xNormalized);
        }

        @Override
        public T value(double xNormalized) {
            SmoothStepFactory.checkBetweenZeroAndOneIncluded(xNormalized);
            Field field = this.getField();
            CalculusFieldElement one = (CalculusFieldElement)field.getOne();
            if (xNormalized >= 0.0 && xNormalized <= 0.5) {
                return (T)((CalculusFieldElement)one.newInstance(2.0 * xNormalized * xNormalized));
            }
            return (T)((CalculusFieldElement)one.newInstance(4.0 * xNormalized - 2.0 * xNormalized * xNormalized - 1.0));
        }

        @Override
        public T value(T xNormalized) {
            SmoothStepFactory.checkBetweenZeroAndOneIncluded(xNormalized.getReal());
            if (xNormalized.getReal() >= 0.0 && xNormalized.getReal() <= 0.5) {
                return (T)((CalculusFieldElement)((CalculusFieldElement)xNormalized.multiply(xNormalized)).multiply(2.0));
            }
            CalculusFieldElement one = (CalculusFieldElement)this.getField().getOne();
            return (T)((CalculusFieldElement)one.linearCombination(4.0, xNormalized, -2.0, (CalculusFieldElement)xNormalized.multiply(xNormalized)).subtract(1.0));
        }
    }

    public static class FieldSmoothStepFunction<T extends CalculusFieldElement<T>>
    extends FieldPolynomialFunction<T> {
        private FieldSmoothStepFunction(T[] c) throws MathIllegalArgumentException, NullArgumentException {
            super(c);
        }

        @Override
        public T value(double xNormalized) {
            SmoothStepFactory.checkBetweenZeroAndOneIncluded(xNormalized);
            return super.value(xNormalized);
        }

        @Override
        public T value(T xNormalized) {
            SmoothStepFactory.checkBetweenZeroAndOneIncluded(xNormalized.getReal());
            return super.value(xNormalized);
        }

        public T value(double leftEdge, double rightEdge, T x) throws MathIllegalArgumentException {
            this.checkInputEdges(leftEdge, rightEdge);
            T xClamped = this.clampInput(leftEdge, rightEdge, x);
            T xNormalized = this.normalizeInput(leftEdge, rightEdge, xClamped);
            return super.value(xNormalized);
        }

        protected void checkInputEdges(double leftEdge, double rightEdge) {
            if (leftEdge > rightEdge) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.RIGHT_EDGE_GREATER_THAN_LEFT_EDGE, leftEdge, rightEdge);
            }
        }

        protected T clampInput(double leftEdge, double rightEdge, T x) {
            if (x.getReal() <= leftEdge) {
                return (T)((CalculusFieldElement)((CalculusFieldElement)x.getField().getOne()).newInstance(leftEdge));
            }
            if (x.getReal() >= rightEdge) {
                return (T)((CalculusFieldElement)((CalculusFieldElement)x.getField().getOne()).newInstance(rightEdge));
            }
            return x;
        }

        protected T normalizeInput(double leftEdge, double rightEdge, T x) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)x.subtract((double)leftEdge)).divide(rightEdge - leftEdge));
        }
    }

    public static class QuadraticSmoothStepFunction
    extends SmoothStepFunction {
        private static final long serialVersionUID = 20230422L;

        private QuadraticSmoothStepFunction(double[] c) throws MathIllegalArgumentException, NullArgumentException {
            super(c);
        }

        @Override
        public double value(double leftEdge, double rightEdge, double x) throws MathIllegalArgumentException {
            this.checkInputEdges(leftEdge, rightEdge);
            double xClamped = this.clampInput(leftEdge, rightEdge, x);
            double xNormalized = this.normalizeInput(leftEdge, rightEdge, xClamped);
            return this.value(xNormalized);
        }

        @Override
        public double value(double xNormalized) {
            SmoothStepFactory.checkBetweenZeroAndOneIncluded(xNormalized);
            if (xNormalized >= 0.0 && xNormalized <= 0.5) {
                return 2.0 * xNormalized * xNormalized;
            }
            return 4.0 * xNormalized - 2.0 * xNormalized * xNormalized - 1.0;
        }
    }

    public static class SmoothStepFunction
    extends PolynomialFunction {
        private static final long serialVersionUID = 20230113L;

        private SmoothStepFunction(double[] c) throws MathIllegalArgumentException, NullArgumentException {
            super(c);
        }

        @Override
        public double value(double xNormalized) {
            SmoothStepFactory.checkBetweenZeroAndOneIncluded(xNormalized);
            return super.value(xNormalized);
        }

        public double value(double leftEdge, double rightEdge, double x) throws MathIllegalArgumentException {
            this.checkInputEdges(leftEdge, rightEdge);
            double xClamped = this.clampInput(leftEdge, rightEdge, x);
            double xNormalized = this.normalizeInput(leftEdge, rightEdge, xClamped);
            return super.value(xNormalized);
        }

        protected void checkInputEdges(double leftEdge, double rightEdge) {
            if (leftEdge > rightEdge) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.RIGHT_EDGE_GREATER_THAN_LEFT_EDGE, leftEdge, rightEdge);
            }
        }

        protected double clampInput(double leftEdge, double rightEdge, double x) {
            if (x <= leftEdge) {
                return leftEdge;
            }
            if (x >= rightEdge) {
                return rightEdge;
            }
            return x;
        }

        protected double normalizeInput(double leftEdge, double rightEdge, double x) {
            return (x - leftEdge) / (rightEdge - leftEdge);
        }
    }
}

