/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class ExponentialDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20160320L;
    private final double mean;
    private final double logMean;

    public ExponentialDistribution(double mean) throws MathIllegalArgumentException {
        if (mean <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.MEAN, mean);
        }
        this.mean = mean;
        this.logMean = FastMath.log(mean);
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double density(double x) {
        double logDensity = this.logDensity(x);
        return logDensity == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logDensity);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -x / this.mean - this.logMean;
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-x / this.mean);
        return ret;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        double ret = p == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * FastMath.log(1.0 - p);
        return ret;
    }

    @Override
    public double getNumericalMean() {
        return this.getMean();
    }

    @Override
    public double getNumericalVariance() {
        double m = this.getMean();
        return m * m;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

