/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.special.Erf;
import org.hipparchus.util.FastMath;

public class LogNormalDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20120112L;
    private static final double SQRT2PI = FastMath.sqrt(Math.PI * 2);
    private static final double SQRT2 = FastMath.sqrt(2.0);
    private final double location;
    private final double shape;
    private final double logShapePlusHalfLog2Pi;

    public LogNormalDistribution() {
        this(0.0, 1.0);
    }

    public LogNormalDistribution(double location, double shape) throws MathIllegalArgumentException {
        this(location, shape, 1.0E-9);
    }

    public LogNormalDistribution(double location, double shape, double inverseCumAccuracy) throws MathIllegalArgumentException {
        super(inverseCumAccuracy);
        if (shape <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SHAPE, shape);
        }
        this.location = location;
        this.shape = shape;
        this.logShapePlusHalfLog2Pi = FastMath.log(shape) + 0.5 * FastMath.log(Math.PI * 2);
    }

    public double getLocation() {
        return this.location;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double x0 = FastMath.log(x) - this.location;
        double x1 = x0 / this.shape;
        return FastMath.exp(-0.5 * x1 * x1) / (this.shape * SQRT2PI * x);
    }

    @Override
    public double logDensity(double x) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double logX = FastMath.log(x);
        double x0 = logX - this.location;
        double x1 = x0 / this.shape;
        return -0.5 * x1 * x1 - (this.logShapePlusHalfLog2Pi + logX);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double dev = FastMath.log(x) - this.location;
        if (FastMath.abs(dev) > 40.0 * this.shape) {
            return dev < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 + 0.5 * Erf.erf(dev / (this.shape * SQRT2));
    }

    @Override
    public double probability(double x0, double x1) throws MathIllegalArgumentException {
        if (x0 > x1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, x0, x1, true);
        }
        if (x0 <= 0.0 || x1 <= 0.0) {
            return super.probability(x0, x1);
        }
        double denom = this.shape * SQRT2;
        double v0 = (FastMath.log(x0) - this.location) / denom;
        double v1 = (FastMath.log(x1) - this.location) / denom;
        return 0.5 * Erf.erf(v0, v1);
    }

    @Override
    public double getNumericalMean() {
        double s = this.shape;
        return FastMath.exp(this.location + s * s / 2.0);
    }

    @Override
    public double getNumericalVariance() {
        double s = this.shape;
        double ss = s * s;
        return FastMath.expm1(ss) * FastMath.exp(2.0 * this.location + ss);
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

