/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.special.Gamma;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class WeibullDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20160320L;
    private final double shape;
    private final double scale;

    public WeibullDistribution(double alpha, double beta) throws MathIllegalArgumentException {
        if (alpha <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SHAPE, alpha);
        }
        if (beta <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SCALE, beta);
        }
        this.scale = beta;
        this.shape = alpha;
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double xscale = x / this.scale;
        double xscalepow = FastMath.pow(xscale, this.shape - 1.0);
        double xscalepowshape = xscalepow * xscale;
        return this.shape / this.scale * xscalepow * FastMath.exp(-xscalepowshape);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double xscale = x / this.scale;
        double logxscalepow = FastMath.log(xscale) * (this.shape - 1.0);
        double xscalepowshape = FastMath.exp(logxscalepow) * xscale;
        return FastMath.log(this.shape / this.scale) + logxscalepow - xscalepowshape;
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-FastMath.pow(x / this.scale, this.shape));
        return ret;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        double ret = p == 0.0 ? 0.0 : (p == 1.0 ? Double.POSITIVE_INFINITY : this.scale * FastMath.pow(-FastMath.log1p(-p), 1.0 / this.shape));
        return ret;
    }

    @Override
    public double getNumericalMean() {
        double sh = this.getShape();
        double sc = this.getScale();
        return sc * FastMath.exp(Gamma.logGamma(1.0 + 1.0 / sh));
    }

    @Override
    public double getNumericalVariance() {
        double sh = this.getShape();
        double sc = this.getScale();
        double mn = this.getNumericalMean();
        return sc * sc * FastMath.exp(Gamma.logGamma(1.0 + 2.0 / sh)) - mn * mn;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

