/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.multivariate;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.distribution.MultivariateRealDistribution;
import org.hipparchus.distribution.multivariate.AbstractMultivariateRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.Well19937c;
import org.hipparchus.util.Pair;

public class MixtureMultivariateRealDistribution<T extends MultivariateRealDistribution>
extends AbstractMultivariateRealDistribution {
    private final double[] weight;
    private final List<T> distribution;

    public MixtureMultivariateRealDistribution(List<Pair<Double, T>> components) {
        this((RandomGenerator)new Well19937c(), components);
    }

    public MixtureMultivariateRealDistribution(RandomGenerator rng, List<Pair<Double, T>> components) {
        super(rng, ((MultivariateRealDistribution)components.get(0).getSecond()).getDimension());
        int numComp = components.size();
        int dim = this.getDimension();
        double weightSum = 0.0;
        for (Pair<Double, T> comp : components) {
            if (((MultivariateRealDistribution)comp.getSecond()).getDimension() != dim) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, ((MultivariateRealDistribution)comp.getSecond()).getDimension(), dim);
            }
            if (comp.getFirst() < 0.0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, comp.getFirst(), 0);
            }
            weightSum += comp.getFirst().doubleValue();
        }
        if (Double.isInfinite(weightSum)) {
            throw new MathRuntimeException(LocalizedCoreFormats.OVERFLOW, new Object[0]);
        }
        this.distribution = new ArrayList<T>();
        this.weight = new double[numComp];
        for (int i = 0; i < numComp; ++i) {
            Pair<Double, T> comp;
            comp = components.get(i);
            this.weight[i] = comp.getFirst() / weightSum;
            this.distribution.add((MultivariateRealDistribution)comp.getSecond());
        }
    }

    @Override
    public double density(double[] values) {
        double p = 0.0;
        for (int i = 0; i < this.weight.length; ++i) {
            p += this.weight[i] * ((MultivariateRealDistribution)this.distribution.get(i)).density(values);
        }
        return p;
    }

    @Override
    public double[] sample() {
        double[] vals = null;
        double randomValue = this.random.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < this.weight.length; ++i) {
            if (!(randomValue <= (sum += this.weight[i]))) continue;
            vals = ((MultivariateRealDistribution)this.distribution.get(i)).sample();
            break;
        }
        if (vals == null) {
            vals = ((MultivariateRealDistribution)this.distribution.get(this.weight.length - 1)).sample();
        }
        return vals;
    }

    @Override
    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        for (int i = 0; i < this.distribution.size(); ++i) {
            ((MultivariateRealDistribution)this.distribution.get(i)).reseedRandomGenerator((long)(i + 1) + seed);
        }
    }

    public List<Pair<Double, T>> getComponents() {
        ArrayList<Pair<Double, T>> list = new ArrayList<Pair<Double, T>>(this.weight.length);
        for (int i = 0; i < this.weight.length; ++i) {
            list.add(new Pair<Double, MultivariateRealDistribution>(this.weight[i], (MultivariateRealDistribution)this.distribution.get(i)));
        }
        return list;
    }
}

