/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.multivariate;

import org.hipparchus.distribution.multivariate.AbstractMultivariateRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.EigenDecompositionSymmetric;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.Well19937c;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

public class MultivariateNormalDistribution
extends AbstractMultivariateRealDistribution {
    private static final double DEFAULT_TOLERANCE = Precision.EPSILON;
    private final double[] means;
    private final RealMatrix covarianceMatrix;
    private final RealMatrix covarianceMatrixInverse;
    private final double covarianceMatrixDeterminant;
    private final RealMatrix samplingMatrix;
    private final double singularMatrixCheckTolerance;

    public MultivariateNormalDistribution(double[] means, double[][] covariances) throws MathIllegalArgumentException {
        this(means, covariances, DEFAULT_TOLERANCE);
    }

    public MultivariateNormalDistribution(double[] means, double[][] covariances, double singularMatrixCheckTolerance) throws MathIllegalArgumentException {
        this(new Well19937c(), means, covariances, singularMatrixCheckTolerance);
    }

    public MultivariateNormalDistribution(RandomGenerator rng, double[] means, double[][] covariances) {
        this(rng, means, covariances, DEFAULT_TOLERANCE);
    }

    public MultivariateNormalDistribution(RandomGenerator rng, double[] means, double[][] covariances, double singularMatrixCheckTolerance) throws MathIllegalArgumentException {
        super(rng, means.length);
        double[] covMatEigenvalues;
        int dim = means.length;
        if (covariances.length != dim) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, covariances.length, dim);
        }
        for (int i = 0; i < dim; ++i) {
            if (dim == covariances[i].length) continue;
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, covariances[i].length, dim);
        }
        this.means = (double[])means.clone();
        this.singularMatrixCheckTolerance = singularMatrixCheckTolerance;
        this.covarianceMatrix = new Array2DRowRealMatrix(covariances);
        EigenDecompositionSymmetric covMatDec = new EigenDecompositionSymmetric(this.covarianceMatrix, singularMatrixCheckTolerance, true);
        this.covarianceMatrixInverse = covMatDec.getSolver().getInverse();
        this.covarianceMatrixDeterminant = covMatDec.getDeterminant();
        for (double covMatEigenvalue : covMatEigenvalues = covMatDec.getEigenvalues()) {
            if (!(covMatEigenvalue < 0.0)) continue;
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_POSITIVE_DEFINITE_MATRIX, new Object[0]);
        }
        Array2DRowRealMatrix covMatEigenvectors = new Array2DRowRealMatrix(dim, dim);
        for (int v = 0; v < dim; ++v) {
            double[] evec = covMatDec.getEigenvector(v).toArray();
            covMatEigenvectors.setColumn(v, evec);
        }
        RealMatrix tmpMatrix = covMatEigenvectors.transpose();
        for (int row = 0; row < dim; ++row) {
            double factor = FastMath.sqrt(covMatEigenvalues[row]);
            for (int col = 0; col < dim; ++col) {
                tmpMatrix.multiplyEntry(row, col, factor);
            }
        }
        this.samplingMatrix = covMatEigenvectors.multiply(tmpMatrix);
    }

    public double[] getMeans() {
        return (double[])this.means.clone();
    }

    public RealMatrix getCovariances() {
        return this.covarianceMatrix.copy();
    }

    public double getSingularMatrixCheckTolerance() {
        return this.singularMatrixCheckTolerance;
    }

    @Override
    public double density(double[] vals) throws MathIllegalArgumentException {
        int dim = this.getDimension();
        if (vals.length != dim) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, vals.length, dim);
        }
        return FastMath.pow(Math.PI * 2, -0.5 * (double)dim) * FastMath.pow(this.covarianceMatrixDeterminant, -0.5) * this.getExponentTerm(vals);
    }

    public double[] getStandardDeviations() {
        int dim = this.getDimension();
        double[] std = new double[dim];
        double[][] s = this.covarianceMatrix.getData();
        for (int i = 0; i < dim; ++i) {
            std[i] = FastMath.sqrt(s[i][i]);
        }
        return std;
    }

    @Override
    public double[] sample() {
        int dim = this.getDimension();
        double[] normalVals = new double[dim];
        for (int i = 0; i < dim; ++i) {
            normalVals[i] = this.random.nextGaussian();
        }
        double[] vals = this.samplingMatrix.operate(normalVals);
        for (int i = 0; i < dim; ++i) {
            int n = i;
            vals[n] = vals[n] + this.means[i];
        }
        return vals;
    }

    private double getExponentTerm(double[] values) {
        double[] centered = new double[values.length];
        for (int i = 0; i < centered.length; ++i) {
            centered[i] = values[i] - this.getMeans()[i];
        }
        double[] preMultiplied = this.covarianceMatrixInverse.preMultiply(centered);
        double sum = 0.0;
        for (int i = 0; i < preMultiplied.length; ++i) {
            sum += preMultiplied[i] * centered[i];
        }
        return FastMath.exp(-0.5 * sum);
    }
}

