/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

abstract class FieldDuplication<T extends CalculusFieldElement<T>> {
    private static final int M_MAX = 16;
    private final T[] initialVA;
    private final double q;

    @SafeVarargs
    FieldDuplication(T ... v) {
        Field field = v[0].getField();
        int n = v.length;
        this.initialVA = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(n + 1));
        System.arraycopy(v, 0, this.initialVA, 0, n);
        this.initialMeanPoint((CalculusFieldElement[])this.initialVA);
        CalculusFieldElement max = (CalculusFieldElement)field.getZero();
        T a0 = this.initialVA[n];
        for (T vi : v) {
            max = FastMath.max(max, (CalculusFieldElement)((CalculusFieldElement)a0.subtract(vi)).abs());
        }
        this.q = this.convergenceCriterion(FastMath.ulp((CalculusFieldElement)field.getOne()), max).getReal();
    }

    protected T getVi(int i) {
        return this.initialVA[i];
    }

    protected abstract void initialMeanPoint(T[] var1);

    protected abstract T convergenceCriterion(T var1, T var2);

    protected abstract void update(int var1, T[] var2, T[] var3, double var4);

    protected abstract T evaluate(T[] var1, T var2, double var3);

    public T integral() {
        int n = this.initialVA.length - 1;
        CalculusFieldElement[] vaM = (CalculusFieldElement[])this.initialVA.clone();
        CalculusFieldElement[] sqrtM = (CalculusFieldElement[])MathArrays.buildArray(this.initialVA[0].getField(), (int)n);
        double fourM = 1.0;
        for (int m = 0; !(m >= 16 || m > 0 && this.q < fourM * vaM[n].norm()); ++m) {
            for (int i = 0; i < n; ++i) {
                sqrtM[i] = (CalculusFieldElement)vaM[i].sqrt();
            }
            this.update(m, vaM, sqrtM, fourM);
            fourM *= 4.0;
        }
        return (T)this.evaluate((CalculusFieldElement[])this.initialVA, vaM[n], fourM);
    }
}

