/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.jacobi.FieldTheta;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;

public class FieldJacobiTheta<T extends CalculusFieldElement<T>> {
    private static final int N_MAX = 100;
    private final T q;
    private final T qSquare;
    private final T qFourth;

    public FieldJacobiTheta(T q) {
        this.q = q;
        this.qSquare = (CalculusFieldElement)q.multiply(q);
        this.qFourth = FastMath.sqrt(FastMath.sqrt(q));
    }

    public T getQ() {
        return this.q;
    }

    public FieldTheta<T> values(T z) {
        CalculusFieldElement zero = (CalculusFieldElement)this.q.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)this.q.getField().getOne();
        FieldSinCos<T> sc1 = FastMath.sinCos(z);
        double sgn = 1.0;
        CalculusFieldElement qNN = one;
        CalculusFieldElement qTwoN = one;
        CalculusFieldElement qNNp1 = one;
        FieldSinCos<T> sc2n1 = sc1;
        double eps = FastMath.ulp(one).getReal();
        CalculusFieldElement sum1 = (CalculusFieldElement)sc1.sin();
        CalculusFieldElement sum2 = (CalculusFieldElement)sc1.cos();
        CalculusFieldElement sum3 = zero;
        CalculusFieldElement sum4 = zero;
        for (int n = 1; n < 100; ++n) {
            sgn = -sgn;
            qNN = (CalculusFieldElement)qNN.multiply(qTwoN).multiply(this.q);
            qTwoN = (CalculusFieldElement)qTwoN.multiply(this.qSquare);
            qNNp1 = qNNp1.multiply(qTwoN);
            sc2n1 = FieldSinCos.sum(sc2n1, sc1);
            sum3 = sum3.add(((CalculusFieldElement)sc2n1.cos()).multiply(qNN));
            sum4 = sum4.add(((CalculusFieldElement)sc2n1.cos()).multiply((CalculusFieldElement)qNN.multiply(sgn)));
            sc2n1 = FieldSinCos.sum(sc2n1, sc1);
            sum1 = sum1.add(((CalculusFieldElement)sc2n1.sin()).multiply((CalculusFieldElement)qNNp1.multiply(sgn)));
            sum2 = sum2.add(((CalculusFieldElement)sc2n1.cos()).multiply(qNNp1));
            if (qNNp1.norm() <= eps) break;
        }
        return new FieldTheta<CalculusFieldElement>(sum1.multiply((CalculusFieldElement)this.qFourth.multiply(2)), sum2.multiply((CalculusFieldElement)this.qFourth.multiply(2)), (CalculusFieldElement)((CalculusFieldElement)sum3.multiply(2)).add(1.0), (CalculusFieldElement)((CalculusFieldElement)sum4.multiply(2)).add(1.0));
    }
}

