/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.hipparchus.util.FastMath;

public abstract class AbstractOpenIntHashMap {
    protected static final int DEFAULT_EXPECTED_SIZE = 16;
    protected static final int RESIZE_MULTIPLIER = 2;
    private static final byte FREE = 0;
    private static final byte FULL = 1;
    private static final byte REMOVED = 2;
    private static final float LOAD_FACTOR = 0.5f;
    private static final int PERTURB_SHIFT = 5;
    private int[] keys;
    private byte[] states;
    private int size;
    private int mask;
    private transient int count;

    protected AbstractOpenIntHashMap() {
        this(16);
    }

    protected AbstractOpenIntHashMap(int expectedSize) {
        int capacity = AbstractOpenIntHashMap.computeCapacity(expectedSize);
        this.keys = new int[capacity];
        this.states = new byte[capacity];
        this.mask = capacity - 1;
        this.resetCount();
    }

    protected AbstractOpenIntHashMap(AbstractOpenIntHashMap source) {
        int length = source.keys.length;
        this.keys = new int[length];
        System.arraycopy(source.keys, 0, this.keys, 0, length);
        this.states = new byte[length];
        System.arraycopy(source.states, 0, this.states, 0, length);
        this.size = source.size;
        this.mask = source.mask;
        this.count = source.count;
    }

    protected int getCapacity() {
        return this.keys.length;
    }

    public int getSize() {
        return this.size;
    }

    private static int computeCapacity(int expectedSize) {
        if (expectedSize == 0) {
            return 1;
        }
        int capacity = (int)FastMath.ceil((float)expectedSize / 0.5f);
        int powerOfTwo = Integer.highestOneBit(capacity);
        if (powerOfTwo == capacity) {
            return capacity;
        }
        return AbstractOpenIntHashMap.nextPowerOfTwo(capacity);
    }

    protected final void resetCount() {
        this.count = 0;
    }

    private static int nextPowerOfTwo(int i) {
        return Integer.highestOneBit(i) << 1;
    }

    public boolean containsKey(int key) {
        int hash = AbstractOpenIntHashMap.hashOf(key);
        int index = hash & this.mask;
        if (this.containsKey(key, index)) {
            return true;
        }
        if (this.states[index] == 0) {
            return false;
        }
        int j = index;
        int perturb = AbstractOpenIntHashMap.perturb(hash);
        while (this.states[index] != 0) {
            index = (j = AbstractOpenIntHashMap.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index)) {
                return true;
            }
            perturb >>= 5;
        }
        return false;
    }

    private static int perturb(int hash) {
        return hash & Integer.MAX_VALUE;
    }

    private static int findInsertionIndex(int[] keys, byte[] states, int key, int mask) {
        int hash = AbstractOpenIntHashMap.hashOf(key);
        int index = hash & mask;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && keys[index] == key) {
            return AbstractOpenIntHashMap.changeIndexSign(index);
        }
        int perturb = AbstractOpenIntHashMap.perturb(hash);
        int j = index;
        if (states[index] == 1) {
            do {
                j = AbstractOpenIntHashMap.probe(perturb, j);
                index = j & mask;
                perturb >>= 5;
            } while (states[index] == 1 && keys[index] != key);
        }
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1) {
            return AbstractOpenIntHashMap.changeIndexSign(index);
        }
        int firstRemoved = index;
        while (states[index = (j = AbstractOpenIntHashMap.probe(perturb, j)) & mask] != 0) {
            if (states[index] == 1 && keys[index] == key) {
                return AbstractOpenIntHashMap.changeIndexSign(index);
            }
            perturb >>= 5;
        }
        return firstRemoved;
    }

    private static int probe(int perturb, int j) {
        return (j << 2) + j + perturb + 1;
    }

    private static int changeIndexSign(int index) {
        return -index - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(int key, int index) {
        return (key != 0 || this.states[index] == 1) && this.keys[index] == key;
    }

    protected int locate(int key) {
        int hash = AbstractOpenIntHashMap.hashOf(key);
        int index = hash & this.mask;
        if (this.containsKey(key, index)) {
            return index;
        }
        if (this.states[index] == 0) {
            return -1;
        }
        int j = index;
        int perturb = AbstractOpenIntHashMap.perturb(hash);
        while (this.states[index] != 0) {
            index = (j = AbstractOpenIntHashMap.probe(perturb, j)) & this.mask;
            if (this.containsKey(key, index)) {
                return index;
            }
            perturb >>= 5;
        }
        return -1;
    }

    protected void doRemove(int index) {
        this.keys[index] = 0;
        this.states[index] = 2;
        --this.size;
        ++this.count;
    }

    protected InsertionHolder put(int key) {
        int oldIndex;
        int newIndex = oldIndex = AbstractOpenIntHashMap.findInsertionIndex(this.keys, this.states, key, this.mask);
        boolean existing = false;
        boolean newMapping = true;
        if (oldIndex < 0) {
            oldIndex = AbstractOpenIntHashMap.changeIndexSign(oldIndex);
            existing = true;
            newMapping = false;
        }
        this.keys[oldIndex] = key;
        this.states[oldIndex] = 1;
        if (newMapping) {
            ++this.size;
            if (this.shouldGrowTable()) {
                newIndex = this.growTable(oldIndex);
            }
            ++this.count;
        }
        return new InsertionHolder(existing ? oldIndex : newIndex, existing);
    }

    protected abstract int growTable(int var1);

    protected int doGrowTable(int oldIndex, ValueCopier valueCopier) {
        int newIndex = oldIndex;
        int oldLength = this.states.length;
        int[] oldKeys = this.keys;
        byte[] oldStates = this.states;
        int newLength = 2 * oldLength;
        int[] newKeys = new int[newLength];
        byte[] newStates = new byte[newLength];
        int newMask = newLength - 1;
        for (int srcIndex = 0; srcIndex < oldLength; ++srcIndex) {
            if (oldStates[srcIndex] != 1) continue;
            int key = oldKeys[srcIndex];
            int dstIndex = AbstractOpenIntHashMap.findInsertionIndex(newKeys, newStates, key, newMask);
            newKeys[dstIndex] = key;
            valueCopier.copyValue(srcIndex, dstIndex);
            if (srcIndex == oldIndex) {
                newIndex = dstIndex;
            }
            newStates[dstIndex] = 1;
        }
        this.mask = newMask;
        this.keys = newKeys;
        this.states = newStates;
        return newIndex;
    }

    private boolean shouldGrowTable() {
        return (float)this.size > (float)(this.mask + 1) * 0.5f;
    }

    private static int hashOf(int key) {
        int h = key ^ (key >>> 20 ^ key >>> 12);
        return h ^ h >>> 7 ^ h >>> 4;
    }

    protected boolean equalKeys(AbstractOpenIntHashMap other) {
        return Arrays.equals(this.keys, other.keys);
    }

    protected boolean equalStates(AbstractOpenIntHashMap other) {
        return Arrays.equals(this.states, other.states);
    }

    protected int keysStatesHashCode() {
        return 53 * Arrays.hashCode(this.keys) + 31 * Arrays.hashCode(this.states);
    }

    @FunctionalInterface
    protected static interface ValueCopier {
        public void copyValue(int var1, int var2);
    }

    protected static class InsertionHolder {
        private final int index;
        private final boolean existing;

        InsertionHolder(int index, boolean existing) {
            this.index = index;
            this.existing = existing;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isExisting() {
            return this.existing;
        }
    }

    protected class BaseIterator {
        private final int referenceCount;
        private int current;
        private int next;

        protected BaseIterator() {
            this.referenceCount = AbstractOpenIntHashMap.this.count;
            this.next = -1;
            try {
                this.advance();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }

        public boolean hasNext() {
            return this.next >= 0;
        }

        protected int getCurrent() {
            return this.current;
        }

        public int key() throws ConcurrentModificationException, NoSuchElementException {
            return AbstractOpenIntHashMap.this.keys[this.getCurrent()];
        }

        public void advance() throws ConcurrentModificationException, NoSuchElementException {
            block4: {
                if (this.referenceCount != AbstractOpenIntHashMap.this.count) {
                    throw new ConcurrentModificationException();
                }
                this.current = this.next;
                try {
                    while (AbstractOpenIntHashMap.this.states[++this.next] != 1) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.next = -2;
                    if (this.current >= 0) break block4;
                    throw new NoSuchElementException();
                }
            }
        }
    }
}

