/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.vector.constrained.Constraint;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public abstract class BoundedConstraint
implements Constraint {
    private final RealVector lower;
    private final RealVector upper;

    protected BoundedConstraint(RealVector lower, RealVector upper) {
        if (lower == null) {
            MathUtils.checkNotNull((Object)upper);
            this.lower = MatrixUtils.createRealVector((int)upper.getDimension());
            this.lower.set(Double.NEGATIVE_INFINITY);
        } else {
            this.lower = lower;
        }
        if (upper == null) {
            this.upper = MatrixUtils.createRealVector((int)lower.getDimension());
            this.upper.set(Double.POSITIVE_INFINITY);
        } else {
            this.upper = upper;
        }
        MathUtils.checkDimension((int)this.lower.getDimension(), (int)this.upper.getDimension());
    }

    @Override
    public int dimY() {
        return this.lower.getDimension();
    }

    @Override
    public RealVector getLowerBound() {
        return this.lower;
    }

    @Override
    public RealVector getUpperBound() {
        return this.upper;
    }

    @Override
    public double overshoot(RealVector y) {
        double overshoot = 0.0;
        for (int i = 0; i < y.getDimension(); ++i) {
            overshoot += FastMath.max((double)0.0, (double)(this.lower.getEntry(i) - y.getEntry(i)));
            overshoot += FastMath.max((double)0.0, (double)(y.getEntry(i) - this.upper.getEntry(i)));
        }
        return overshoot;
    }
}

