/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.clustering.evaluation;

import java.util.List;
import org.hipparchus.clustering.Cluster;
import org.hipparchus.clustering.Clusterable;
import org.hipparchus.clustering.distance.DistanceMeasure;
import org.hipparchus.clustering.evaluation.ClusterEvaluator;
import org.hipparchus.stat.descriptive.moment.Variance;

public class SumOfClusterVariances<T extends Clusterable>
extends ClusterEvaluator<T> {
    public SumOfClusterVariances(DistanceMeasure measure) {
        super(measure);
    }

    @Override
    public double score(List<? extends Cluster<T>> clusters) {
        double varianceSum = 0.0;
        for (Cluster<T> cluster : clusters) {
            if (cluster.getPoints().isEmpty()) continue;
            Clusterable center = this.centroidOf(cluster);
            Variance stat = new Variance();
            for (Clusterable point : cluster.getPoints()) {
                stat.increment(this.distance(point, center));
            }
            varianceSum += stat.getResult();
        }
        return varianceSum;
    }
}

